/**
 * WordPress provides React during the page load. This is for TypeScript type checking only.
 *
 * Importing React from @wordpress/element causes "Cannot read property 'createElement' of undefined"
 */
import React from 'react';
import { useBlockProps, InnerBlocks, InspectorControls } from '@wordpress/block-editor';
import { __ } from '@wordpress/i18n';
import { PanelBody, TextareaControl } from '@wordpress/components';

export interface GPEntriesLoopBlockAttributes {
	noEntriesFoundMessage: string
}

// @todo should this be renamed to something like Entry Loop Template?
// @todo can we add some sort of toggle in the block controls to render the loop using something similar to <BlockPreview>?
const Edit = ( args: BlockProps< GPEntriesLoopBlockAttributes > ) => {
	const blockProps = useBlockProps();

	const inspectorControls = (
		<InspectorControls>
			{ args.context[ 'gp-entry-blocks/formId' ] && (
				<>
					<PanelBody
						className="gpeb_panel_entries_table_settings"
						title={ __( 'Messages', 'gp-entry-blocks' ) }
					>
						<TextareaControl
							value={ args.attributes.noEntriesFoundMessage }
							onChange={ ( noEntriesFoundMessage ) =>
								args.setAttributes( { noEntriesFoundMessage } )
							}
							label={ __( 'No Entries Found', 'gp-entry-blocks' ) }
						/>
					</PanelBody>
				</>
			) }
		</InspectorControls>
	);

	return (
		<>
			{ inspectorControls }
			<div { ...blockProps }>
				<InnerBlocks />
			</div>
		</>
	);
};

const Save = () => {
	const blockProps = useBlockProps.save();

	return (
		<div { ...blockProps }>
			<InnerBlocks.Content />
		</div>
	);
};

export const settings = {
	edit: Edit,
	save: Save,
};
