<?php

/*
 * Plugin Name: Field Icons Gravity Forms
 * Plugin URI: https://wpmonks.com/downloads/field-icons
 * Description: Set icons for Gravity Form Fields
 * Author: Sushil Kumar
 * Author URI: https://wpmonks.com
 * Version: 2.3.2
 * License: GPLv2
 */

// don't load directly
if ( ! defined( 'ABSPATH' ) ) die( '-1' );
//file to send automatic updates
include_once WP_PLUGIN_DIR . "/" . basename( dirname( __FILE__ ) ) . '/update.php';
//set constants for plugin directory and plugin url
define( "GF_STLA_FIELD_ICONS_DIR", WP_PLUGIN_DIR . "/" . basename( dirname( __FILE__ ) ) );
define( "GF_STLA_FIELD_ICONS_URL", plugins_url() . "/" . basename( dirname( __FILE__ ) ) );
define( "GF_STLA_FIELD_ICONS_VERSION", "2.3.2" );

class Gravity_Field_Icons {
	//public $all_found_forms_ids = array();
	private $is_frontend = false;
	private $selected_form_id = '';
	private $form_object = '';
	private $input_fields = array( 'text', 'number', 'email', 'website', 'date', 'phone', 'post_title', 'post_tags', 'quantity', 'post_custom_field','username','textarea' ) ;
	private $complex_fields = array( 'name', 'address', 'email' );
	function __construct() {

		//modify text, dropdowns, radio, checkbox fields
		add_filter( 'gform_field_content', array( $this, 'add_fontawesome_support' ), 10, 5 );
		$this->selected_form_id = get_option( 'gf_stla_select_form_id' );
		add_action( 'gf_stla_add_theme_section', array( $this, 'gf_stla_add_field_icons_section' ), 13, 2 );
		if ( class_exists( 'RGFormsModel' ) ) {
			$this->get_form_fields = RGFormsModel::get_form_meta( $this->selected_form_id );
			$this->form_object = GFAPI::get_form( $this->selected_form_id );
		}
		
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'customizer_styles_scripts' ) );
		add_filter( 'gform_pre_render', array( $this, 'show_field_icons_in_frontend' ) );
		add_action( 'customize_preview_init', array( $this, 'live_preview' ) );

		// enqueue styles & scripts for gravity forms
		add_action( 'gform_enqueue_scripts', array( $this, 'gform_styles_scripts' ), 10, 2 );


		//modify structure of next button
		add_filter( 'gform_next_button', array( $this, 'next_input_to_button' ), 15, 2 );

		//modify structure of previous button
		add_filter( 'gform_previous_button', array( $this, 'previous_input_to_button' ), 15, 2 );

		//modify structure of submit button
		add_filter( 'gform_submit_button', array( $this, 'submit_input_to_button' ), 15, 2 );

		//Check plugin dependency
		add_action( 'admin_notices', array( $this, 'check_plugin_dependencies' ) );


	} //constructor ends here

	//change submit input tags to buttons
	function submit_input_to_button( $button, $form ) {
		// is_admin doesn't work in gutenberg. used REST_REQUEST for this
		if ( is_admin() || defined( 'REST_REQUEST' ) ) { 
			return $button;
		}
		
		$form_id = $form['id'];
		$get_field_icons = get_option( 'gf_stla_form_id_field_icons_' . $form_id );

		$button_icon_class = ! empty( $get_field_icons['fontawesome']['submit-button'] ) ? $get_field_icons['fontawesome']['submit-button'].' stla-fontawesome-icon' : false;
		// replace the "_" with space(" ") from class name
		$button_icon_class = str_replace("_"," ",$button_icon_class);
		if ( ! $button_icon_class ) {
			return $button;
		}

		$dom = new DOMDocument();
		$dom->loadHTML( $button );

		$inputs = $dom->getElementsByTagName( 'input' );
		$inputs_count = count( $inputs );
		$icon_element = $dom->createElement( 'i' );
		$icon_element->setAttribute( 'class', $button_icon_class );
		
		// no input found.. probably material is active and it
		// has already converted the input to button
		// if( 0 === $inputs_count ) {
			
		// 	$buttons = $dom->getElementsByTagName( 'button' );
			
		// 	foreach( $buttons as $button ) {
		// 		$button_classes = $button->getAttribute( 'class');

		// 		if( strpos( $button_classes, 'mdc-button') !== false ) {
		// 			$icon_element->setAttribute( 'class', $button_class.' mdc-button__icon' );
		// 			$new_button->appendChild( $icon_element );
		// 		}
		// 	}

		// 	$content = utf8_decode( $dom->saveHTML( $dom->documentElement ) );
		// 	return $content;
		// }

		foreach( $inputs as $input ) {
			$new_button = $dom->createElement( 'button' );
			$button_label = $dom->createElement( 'span' );

			// set label content
			$button_label->appendChild( $dom->createTextNode( $input->getAttribute( 'value' ) ) );

			$new_button->appendChild( $button_label );
			foreach ( $input->attributes as $attribute ) {
				if ( $attribute->name == 'class' ) {
					$new_button->setAttribute( $attribute->name, $attribute->value . ' stla-fontawesome' );
				}
				else {
					$new_button->setAttribute( $attribute->name, $attribute->value );
				}
			}

			$new_button->appendChild( $icon_element );
			$input->parentNode->replaceChild( $new_button, $input );
		}
		
		$content = utf8_decode( $dom->saveHTML( $dom->documentElement ) );

		return $content;

		//return $dom->saveHtml( $new_button );
	}

	//change next input tags to buttons
	function next_input_to_button( $button, $form ) {
		// is_admin doesn't work in gutenberg. used REST_REQUEST for this
		if ( is_admin() || defined( 'REST_REQUEST' ) ) { 
			return $button;
		}
		
		$form_id = $form['id'];
		$get_field_icons = get_option( 'gf_stla_form_id_field_icons_' . $form_id );
	
		$button_class = !empty( $get_field_icons['fontawesome']['next-button'] ) ? $get_field_icons['fontawesome']['next-button'] : false;
		
		// replace the "_" with space(" ") from class name
		$button_class = str_replace("_"," ",$button_class);
		if ( ! $button_class ) {
			return $button;
		}
	
		$dom = new DOMDocument();
		$dom->loadHTML( $button );
	
		$inputs = $dom->getElementsByTagName( 'input' );
		$inputs_count = count( $inputs );
		$icon_element = $dom->createElement( 'i' );
		
		$icon_element->setAttribute( 'class', $button_class );

	
		foreach( $inputs as $input ) {
			$new_button = $dom->createElement( 'button' );
			$button_label = $dom->createElement( 'span' );

			// set label content
			$button_label->appendChild( $dom->createTextNode( $input->getAttribute( 'value' ) ) );

			$new_button->appendChild( $button_label );
			foreach ( $input->attributes as $attribute ) {
				if ( $attribute->name == 'class' ) {
					$new_button->setAttribute( $attribute->name, $attribute->value . ' stla-fontawesome' );
				}
				else {
					$new_button->setAttribute( $attribute->name, $attribute->value );
				}
			}

			$new_button->appendChild( $icon_element );
			$input->parentNode->replaceChild( $new_button, $input );
		}
			
			$content = utf8_decode( $dom->saveHTML( $dom->documentElement ) );
			return $content;
			//return $dom->saveHtml( $new_button );
		}

	//change previous tags to buttons
	function previous_input_to_button( $button, $form ) {
		// is_admin doesn't work in gutenberg. used REST_REQUEST for this
		if ( is_admin() || defined( 'REST_REQUEST' ) ) { 
			return $button;
		}
		
		$form_id = $form['id'];
		$get_field_icons = get_option( 'gf_stla_form_id_field_icons_' . $form_id );

		$button_class = !empty( $get_field_icons['fontawesome']['previous-button'] ) ? $get_field_icons['fontawesome']['previous-button'] : false;
		
		// replace the "_" with space(" ") from class name
		$button_class = str_replace("_"," ",$button_class);
		if ( ! $button_class ) {
			return $button;
		}

		$dom = new DOMDocument();
		$dom->loadHTML( $button );

		$inputs = $dom->getElementsByTagName( 'input' );
		$inputs_count = count( $inputs );
		$icon_element = $dom->createElement( 'i' );
		$icon_element->setAttribute( 'class', $button_class );
		
		foreach( $inputs as $input ) {
			$new_button = $dom->createElement( 'button' );
			$button_label = $dom->createElement( 'span' );

			// set label content
			$button_label->appendChild( $dom->createTextNode( $input->getAttribute( 'value' ) ) );

			$new_button->appendChild( $button_label );
			foreach ( $input->attributes as $attribute ) {
				if ( $attribute->name == 'class' ) {
					$new_button->setAttribute( $attribute->name, $attribute->value . ' stla-fontawesome' );
				}
				else {
					$new_button->setAttribute( $attribute->name, $attribute->value );
				}
			}

			$new_button->appendChild( $icon_element );
			$input->parentNode->replaceChild( $new_button, $input );
		}
		
		$content = utf8_decode( $dom->saveHTML( $dom->documentElement ) );

		return $content;

		//return $dom->saveHtml( $new_button );
	}

	function add_fontawesome_support( $content, $field, $value, $lead_id, $form_id ) {
		// is_admin doesn't work in gutenberg. used REST_REQUEST for this
		if ( is_admin() || defined( 'REST_REQUEST' ) ) { 
			return $content;
		}

		$is_complex = false;
		$get_field_icons = get_option( 'gf_stla_form_id_field_icons_' . $form_id );
		$get_field_icons_options = get_option( 'gf_stla_form_id_field_icons_options_' . $form_id );
		if ( ! isset( $get_field_icons_options['icon-type'] ) || $get_field_icons_options['icon-type'] === 'fontawesome' ) {
			$field_id = $field->id;
			$fontawesome_icon = !empty( $get_field_icons['fontawesome'][ $field->type ][ $field->id ] ) ? $get_field_icons['fontawesome'][ $field->type ][ $field->id ]:false;
			if ( isset( $child_field_object_value['isHidden'] ) ) {
				$is_hidden = $child_field_object_value['isHidden'];
			}

			if ( isset( $field->inputs ) && $field->inputs ) {
				$is_complex = true;
			}
			if ( $this->is_frontend && ( $fontawesome_icon || $is_complex ) ) {
				
				$dom = new DOMDocument;
				$dom->loadHTML( $content );
				include GF_STLA_FIELD_ICONS_DIR . '/includes/fontawesome/input.php';
				include GF_STLA_FIELD_ICONS_DIR . '/includes/fontawesome/textarea.php';
				include GF_STLA_FIELD_ICONS_DIR . '/includes/fontawesome/complex.php';
			}
		}

		return $content;
	}

	function gform_styles_scripts( $form, $is_ajax ) {

		// is_admin doesn't work in gutenberg. used REST_REQUEST for this
		if ( is_admin() || defined( 'REST_REQUEST' ) ) { 
			return;
		}

		$form_id = $form['id'];
		$get_field_icons = get_option( 'gf_stla_form_id_field_icons_' . $form_id );

		if ( ! $get_field_icons ) {
			return;
		}
		wp_enqueue_style( 'stla-fieldicons-custom', GF_STLA_FIELD_ICONS_URL . '/css/custom.css', '', GF_STLA_FIELD_ICONS_VERSION );
		wp_enqueue_style( 'stla-fontawesome', GF_STLA_FIELD_ICONS_URL . '/css/all.min.css', '', GF_STLA_FIELD_ICONS_VERSION );
		include GF_STLA_FIELD_ICONS_DIR . '/display/class-styles.php';

	}

	function customizer_styles_scripts() {

		$field_ids = array( 'id' =>$this->form_object['id'] );
		

		//add field ids for fontawesome fields
		foreach ( $this->form_object['fields'] as $field_object ) {
			if ( in_array( $field_object->type, $this->input_fields ) || in_array( $field_object->type, $this->complex_fields ) ) {
				if ( ! $field_object['inputs'] ) {
					$field_id = (string) $field_object->id;
					$field_ids['fontawesome'][$field_id] = $field_object->type;
				}
				else {
					foreach ( $field_object['inputs'] as $child_field_object_value ) {
						$is_hidden = false;
						$child_field_id = (string) $child_field_object_value['id'];
						//var_dump($field_object['inputs']);
						if ( isset( $child_field_object_value['isHidden'] ) ) {
							$is_hidden = $child_field_object_value['isHidden'];
						}
						if ( ! $is_hidden ) {
							//var_dump($child_field_object_value['id']);
							$field_ids['fontawesome'][$child_field_id] = $field_object->type;
						}
					}
				}
			}
		}

		//add ids for image icon fields
		foreach ( $this->form_object['fields'] as $field_object ) {
			if ( in_array( $field_object->type, $this->input_fields ) || in_array( $field_object->type, $this->complex_fields ) ) {
				//add field icons settings and controls

				if ( $field_object->type == "address" ) {
					$field_ids['image'][$field_object->id][] = $field_object->type . '-1';
					$field_ids['image'][$field_object->id][] = $field_object->type . '-2';
					$field_ids['image'][$field_object->id][] = $field_object->type . '-3';
					$field_ids['image'][$field_object->id][] = $field_object->type . '-4';
					$field_ids['image'][$field_object->id][] = $field_object->type . '-5';
				}
				else if ( $field_object->type == "name" ) {
					$field_ids['image'][$field_object->id][] = $field_object->type . '-1';
					$field_ids['image'][$field_object->id][] = $field_object->type . '-2';
					$field_ids['image'][$field_object->id][] = $field_object->type . '-3';
				}

				else {
					$field_ids['image'][$field_object->id][] = $field_object->type;
				}

			}
		}

		
		wp_enqueue_style( 'stla-fieldicons-custom', GF_STLA_FIELD_ICONS_URL . '/css/admin/customizer-custom.css', '', GF_STLA_FIELD_ICONS_VERSION );
		//wp_enqueue_style( 'stla-select2-css', GF_STLA_FIELD_ICONS_URL . '/css/admin/select2.min.css' );
		wp_enqueue_script( 'hide_field_icons_section', GF_STLA_FIELD_ICONS_URL . '/js/admin/hide-field-icons.js', array( 'jquery' ), GF_STLA_FIELD_ICONS_VERSION, true );
		//wp_enqueue_script( 'stla-select2',  GF_STLA_FIELD_ICONS_URL . '/js/admin/select2.full.min.js', array( 'jquery' ), '', true );
		wp_enqueue_script( 'stla-customizer-field-icons', GF_STLA_FIELD_ICONS_URL . '/js/admin/initialize.js', array( 'jquery' ), GF_STLA_FIELD_ICONS_VERSION, true  );
		// wp_enqueue_script( 'stla-fontawesome', GF_STLA_FIELD_ICONS_URL . '/js/fontawesome-all.min.js', array( 'jquery' ) );
		wp_localize_script( 'stla-customizer-field-icons', 'stla_gf_local_ids', $field_ids );
	}

	function live_preview() {
		$form_id = get_option( 'gf_stla_select_form_id' );
		wp_enqueue_script( 'stla-icons-live-preview',  GF_STLA_FIELD_ICONS_URL . '/js/admin/live-preview.js', array( 'jquery' ), GF_STLA_FIELD_ICONS_VERSION, true );
		wp_localize_script( 'stla-icons-live-preview',  'stla_icons', array( 'form_id' => $form_id ) );
	}

	function gf_stla_add_field_icons_section( $wp_customize, $current_form_id ) {
		if ( ! class_exists( 'RGFormsModel' ) ) {
			return;
		}
		$this->selected_form_id = $current_form_id;
		$this->form_object = GFAPI::get_form( $this->selected_form_id );

		include_once GF_STLA_FIELD_ICONS_DIR . '/includes/admin/custom-controls/custom-controls.php';
		// $icon_fields = array( 'phone', 'text', 'quantity', 'post_custom_field', 'post_tags', 'post_title', 'date', 'email', 'website', 'address', 'name', 'number' );
		$field_count = count( $this->form_object );
		$icon_position = array( 'left' => 'Left', 'right'=>'Right' );
		$inputs_not_allowed = array( 'select', 'radio', 'checkbox', 'textarea' );

		//include list of fontawesome icons
		include GF_STLA_FIELD_ICONS_DIR . '/includes/fontawesome/fontawesome-icon-list.php';

		//Add Field Icons section
		$wp_customize->add_section( 'gf_stla_form_id_field_icons' , array(
				'title' => 'Field Icons',
				'panel' => 'gf_stla_panel',
			) );

		// Icon type
		$wp_customize->add_setting( 'gf_stla_form_id_field_icons_options_' . $current_form_id . '[icon-type]' , array(
				'default'     => 'fontawesome',
				//'transport'   => 'postMessage',
				'type' => 'option'
			) );

		$wp_customize->add_control( 'gf_stla_form_id_field_icons_options_' . $current_form_id . '[icon-type]',   array(
				'type' => 'radio',
				'priority' => 10, // Within the section.
				'section' => 'gf_stla_form_id_field_icons', // Required, core or custom.
				'label' => __( 'Icons Type' ),
				'choices'        => array( 'fontawesome' => 'Fontawesome', 'image' => 'Image (Deprecated)' )
			)
		);

		// Icon alignment
		$wp_customize->add_setting( 'gf_stla_form_id_field_icons_options_' . $current_form_id . '[icon-position]' , array(
				'default'     => 'left',
				//'transport'   => 'postMessage',
				'type' => 'option'
			) );

		$wp_customize->add_control( 'gf_stla_form_id_field_icons_options_' . $current_form_id . '[icon-position]',   array(
				'type' => 'radio',
				'priority' => 10, // Within the section.
				'section' => 'gf_stla_form_id_field_icons', // Required, core or custom.
				'label' => __( 'Icons Alignment' ),
				'choices'        => $icon_position,
			)
		);


		$wp_customize->add_setting( 'gf_stla_form_id_field_icons_options_' . $current_form_id . '[icon-padding]' , array(
				'default'     => 25,
				//'transport'   => 'postMessage',
				'type' => 'option'
			) );

		$wp_customize->add_control( new Stla_Customize_Control_Slider( $wp_customize, 'gf_stla_form_id_field_icons_options_' . $current_form_id . '[icon-padding]',   array(
					'type' => 'rangeslider',
					'priority' => 10, // Within the section.
					'section' => 'gf_stla_form_id_field_icons', // Required, core or custom.
					'label' => __( 'Move Text Away from icon' ),
					'input_attrs' => array(
						'min' => 1,
						'max' => 120
					)
				)
			)
		);

		$wp_customize->add_setting( 'gf_stla_form_id_field_icons_options_' . $current_form_id . '[icon-size]' , array(
				'default'     => 20,
				'transport'   => 'postMessage',
				'type' => 'option'
			) );

		$wp_customize->add_control( new Stla_Customize_Control_Slider( $wp_customize, 'gf_stla_form_id_field_icons_options_' . $current_form_id . '[icon-size]',   array(
					'type' => 'rangeslider',
					'priority' => 10, // Within the section.
					'section' => 'gf_stla_form_id_field_icons', // Required, core or custom.
					'label' => __( 'Icons Size' ),
					'input_attrs' => array(
						'min' => 10,
						'max' => 30
					)
				)
			)
		);

		$wp_customize->add_setting( 'gf_stla_form_id_field_icons_options_' . $current_form_id . '[icon-top]' , array(
				'default'     => 5,
				'transport'   => 'postMessage',
				'type' => 'option'
			) );

		$wp_customize->add_control( new Stla_Customize_Control_Slider( $wp_customize, 'gf_stla_form_id_field_icons_options_' . $current_form_id . '[icon-top]',   array(
					'type' => 'rangeslider',
					'priority' => 10, // Within the section.
					'section' => 'gf_stla_form_id_field_icons', // Required, core or custom.
					'label' => __( 'Move Icon Towards Bottom' ),
					'input_attrs' => array(
						'min' => 0,
						'max' => 30
					)
				)
			)
		);

		$wp_customize->add_setting( 'gf_stla_form_id_field_icons_options_' . $current_form_id . '[icon-left]' , array(
				'default'     => 4,
				'transport'   => 'postMessage',
				'type' => 'option'
			) );

		$wp_customize->add_control( new Stla_Customize_Control_Slider( $wp_customize, 'gf_stla_form_id_field_icons_options_' . $current_form_id . '[icon-left]',   array(
					'type' => 'rangeslider',
					'priority' => 10, // Within the section.
					'section' => 'gf_stla_form_id_field_icons', // Required, core or custom.
					'label' => __( 'Move Icon Towards Right' ),
					'input_attrs' => array(
						'min' => 0,
						'max' => 30
					)
				)
			)
		);



		$wp_customize->add_setting( 'gf_stla_form_id_field_icons_options_' . $current_form_id . '[icon-color]' , array(
				'default'     => '#666',
				'transport'   => 'postMessage',
				'type' => 'option'
			) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'gf_stla_form_id_field_icons_options_' . $current_form_id . '[icon-color]',   array(
					'priority' => 10, // Within the section.
					'section' => 'gf_stla_form_id_field_icons', // Required, core or custom.
					'label' => __( 'Icon Color' ),
				)
			)
		);
		//include

		include_once GF_STLA_FIELD_ICONS_DIR . '/includes/custom-image-icons.php';


		foreach ( $this->form_object['fields'] as $field_object ) {

		// checks if inputType of a field in not select, radio, checkbox etc.. 
		// useful for fields in which inputType can be changed by user. Ex. Post Tags
			if ( ! in_array( $field_object->inputType, $inputs_not_allowed ) ) {
			
				if ( in_array( $field_object->type, $this->input_fields ) || in_array( $field_object->type, $this->complex_fields )  ) {

					if ( ! $field_object['inputs'] ) {
						$field_id = (string) $field_object->id;
						$wp_customize->add_setting( 'gf_stla_form_id_field_icons_' . $current_form_id . '[fontawesome][' . $field_object->type . '][' . $field_id . ']' , array(
								'default'     => '',
								//'transport'   => 'postMessage',
								'type' => 'option'
							) );

						$wp_customize->add_control( 'gf_stla_form_id_field_icons_' . $current_form_id . '[fontawesome][' . $field_object->type . '][' . $field_id . ']',   array(
								'type' => 'select',
								'priority' => 10, // Within the section.
								'section' => 'gf_stla_form_id_field_icons', // Required, core or custom.
								'label' => $field_object->label,
								'choices' => $fontawesome_icons,
							)
						);
					}
					
					else {
						$state_field_id = false;
						$country_field_id = false;
						if( $field_object->type === "address" ) {
							$country_field_id = floatval( $field_object['id']. '.6' );
							$address_type = $field_object['addressType'];
							if(	$address_type !== 'international' ) {
								$state_field_id = floatval( $field_object['id']. '.4' );
							}
						}
							
						foreach ( $field_object['inputs'] as  $child_field ) {

							$is_hidden = !empty( $child_field['isHidden'] ) ? $child_field['isHidden'] : false;
							$child_field_id = floatval( $child_field['id'] );

							
							// state field id is only set if its not internation ( then it will be dropdown)
							// country field id will always be dropdown.. skip loop in both cases
							if( $state_field_id === $child_field_id || $country_field_id === $child_field_id ){
								continue;
							}

							if ( ! $is_hidden && ! isset( $child_input['choices'] ) ) {
								$wp_customize->add_setting( 'gf_stla_form_id_field_icons_' . $current_form_id . '[fontawesome][' . $field_object->type . '][' . $child_field_id . ']' , array(
										'default'     => '',
										//'transport'   => 'postMessage',
										'type' => 'option'
									) );

								$wp_customize->add_control( 'gf_stla_form_id_field_icons_' . $current_form_id . '[fontawesome][' . $field_object->type . '][' . $child_field_id . ']',   array(
										'type' => 'select',
										'priority' => 10, // Within the section.
										'section' => 'gf_stla_form_id_field_icons', // Required, core or custom.
										'label' => $child_field['label'],
										'choices' => $fontawesome_icons,
									)
								);
							}
						}
					}
				}
			}
		}

		//  buttons
		if( $field_object['pageNumber'] > 1 ) {
			// Previous button
			$wp_customize->add_setting( 'gf_stla_form_id_field_icons_' . $current_form_id . '[fontawesome][previous-button]', array(
				'default'     => '',
				'type' => 'option'
				) 
			);

			$wp_customize->add_control( 'gf_stla_form_id_field_icons_' . $current_form_id . '[fontawesome][previous-button]',   array(
				'type' => 'select',
				'priority' => 10, // Within the section.
				'section' => 'gf_stla_form_id_field_icons', // Required, core or custom.
				'label' => 'Previous Button',
				'choices' => $fontawesome_icons
				)
			);

			// Next Button
			$wp_customize->add_setting( 'gf_stla_form_id_field_icons_' . $current_form_id . '[fontawesome][next-button]', array(
				'default'     => '',
				'type' => 'option'
				) 
			);

			$wp_customize->add_control( 'gf_stla_form_id_field_icons_' . $current_form_id . '[fontawesome][next-button]',   array(
				'type' => 'select',
				'priority' => 10, // Within the section.
				'section' => 'gf_stla_form_id_field_icons', // Required, core or custom.
				'label' => 'Next Button',
				'choices' => $fontawesome_icons
				)
			);
		}

		// submit button
		$wp_customize->add_setting( 'gf_stla_form_id_field_icons_' . $current_form_id . '[fontawesome][submit-button]', array(
			'default'     => '',
			'type' => 'option'
			) 
		);

		$wp_customize->add_control( 'gf_stla_form_id_field_icons_' . $current_form_id . '[fontawesome][submit-button]',   array(
			'type' => 'select',
			'priority' => 10, // Within the section.
			'section' => 'gf_stla_form_id_field_icons', // Required, core or custom.
			'label' => 'Submit Button',
			'choices' => $fontawesome_icons
			)
		);
	}

	function show_field_icons_in_frontend( $form ) {
		$this->is_frontend = true;
		return $form;
	}

	/**
	 * Check if Styles & Layouts is installed or not
	 *
	 * @return void
	 */
	function check_plugin_dependencies() {
		if ( ! class_exists( 'Gravity_customizer_admin' ) ) {
			$class = 'notice notice-error';
			$styles_layouts_url = admin_url( 'plugin-install.php?s=styles+and+layouts+for+gravity+forms&tab=search&type=term');
			$message = '<a href="'.$styles_layouts_url.'">Styles & Layouts for Gravity Forms </a>is not installed. <strong>Gravity Forms Bootstrap Design</strong> can\'t work without it.';

			printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ),  $message  );
		}
	}

} //class ends here


add_action( 'plugins_loaded', 'stla_gravity_field_icons' );

function stla_gravity_field_icons() {
	new Gravity_Field_Icons();
}
