<?php
/***************************************** for complex fields like address and name *************************************/

if ( in_array( $field->type, $complex_fields ) ) {
	$is_complex_field = false;
	$contains_error = false;

	//check if error is present
	$all_divs = $dom->getElementsByTagName( 'div' );
	$get_spans = $dom->getElementsByTagName( 'span' );

	foreach ( $all_divs as $current_div ) {
		$current_div_classes = $current_div->getAttribute( 'class' );
		if ( strpos( $current_div_classes, 'ginput_complex' ) !== false ) {
			$is_complex_field = true;
		}
	}
	// Complex field only then process it.. ( added because of confirm email )
	if ( $is_complex_field  ) {
		// Check if error class is present.. then add material error
		foreach ( $all_divs as $current_div ) {
			$current_div_classes = $current_div->getAttribute( 'class' );
			if ( strpos( $current_div_classes, 'validation_message' ) !== false ) {
				$contains_error = true;
				$current_div->setAttribute( 'class', $current_div->getAttribute( 'class' ) . ' mdc-text-field-helper-text mdc-text-field-helper-text--persistent mdc-text-field-helper-text--validation-msg' );
			}
		}

		// Add classes to the main field label
		$labels = $dom->getElementsByTagName('label');

		// foreach( $labels as $label ) {
		// 	$label_classes = $label->getAttribute( 'class' );

		// 	if ( strpos( $label_classes, 'gfield_label_before_complex' ) !== false ) {
		// 		$add_label_classes = ' mdc-floating-label mdc-floating-label--float-above stla-mat-top-label';
		// 		$label->setAttribute( 'class',	$label->getAttribute( 'class' ) . $add_label_classes );
		// 	}
		// }


		// Loop inside all the spans
		foreach ( $get_spans as $input_element ) {
			$span_classes = $input_element->getAttribute( 'class' );
			// Only modify fields if first, middle , last name or address field except for country selection
			if ( strpos( $span_classes, 'name_' ) !== false || strpos( $span_classes, 'address_' ) !== false  ) {
				
				if ( strpos( $span_classes, 'address_country' ) === false ) {

					//if inputs present then add div before them and add classes ( added because state can be dropdown by changing address type field)
					$inputs = $input_element->getElementsByTagName( 'input' );
					foreach ( $inputs as $input ) {
						//create a new div to append to span

						$container_div = $dom->createElement( 'div' );
						// $container_div->setAttribute( 'class', 'MDCTextField' );
						$input_element->appendChild( $container_div );


						//get newly appended container div
						$container_div = $input_element->getElementsByTagName( 'div' )->item( 0 );

						// get icons
						$icons = $input_element->getElementsByTagName('i');
						$icon_parent_class = '';
						foreach( $icons as $icon ) {
							$icon_classes = $icon->getAttribute('class');
							if ( strpos( $icon_classes, 'stla-fontawesome-icon') !== false) {
								$icon_parent_class = 'mdc-text-field--with-leading-icon';
								$icon->setAttribute('class', $icon->getAttribute('class') . ' mdc-text-field__icon');
								
								// append icon as the first child
								$container_div->appendChild( $icon );
							}
						}

						$add_classes = ' stla_material_large mdc-text-field '.$icon_parent_class;
						$add_classes .= $type === 'outlined' ? ' mdc-text-field--outlined': '';

						if ( $contains_error ) {
							$add_classes .= ' mdc-text-field--invalid';
						}


						$container_div->setAttribute( 'class',
							$container_div->getAttribute( 'class' ) . $add_classes );
						$container_div->setAttribute( 'data-mdc-auto-init', 'MDCTextField' );
						$input->setAttribute( 'class',
							$input->getAttribute( 'class' ) . '  mdc-text-field__input' );

						$container_div->appendChild( $input );

						$add_label_classes = ' mdc-floating-label';
						if ( $input->getAttribute( 'placeholder' ) !== ''  && $type !== 'outlined' ) {
							$add_label_classes .= ' mdc-floating-label--float-above';
						}

						$label = $input_element->getElementsByTagName( 'label' )->item( 0 );
						// outlined design
						if( $type === 'outlined' ) {
							$notched_outline = $dom->createElement('div');
							$notched_outline->setAttribute( 'class', 'mdc-notched-outline' );

							$notched_outline_leading = $dom->createElement( 'div' );
							$notched_outline_leading->setAttribute( 'class', 'mdc-notched-outline__leading' );
							
							$notched_outline_notch = $dom->createElement( 'div' );
							$notched_outline_notch->setAttribute( 'class', 'mdc-notched-outline__notch' );

							$notched_outline_trailing = $dom->createElement( 'div' );
							$notched_outline_trailing->setAttribute( 'class', 'mdc-notched-outline__trailing' );
							
							// if ($contains_placeholder) {
							// 	$notched_outline->setAttribute( 'class', 'mdc-notched-outline mdc-notched-outline--notched' );
							// }
							$container_div->appendChild( $notched_outline );

							$notched_outline->appendChild( $notched_outline_leading );
							$notched_outline->appendChild( $notched_outline_notch );
							$notched_outline->appendChild( $notched_outline_trailing );

							$label->setAttribute('class', $label->getAttribute( 'class' ) . $add_label_classes );
							$notched_outline_notch->appendChild( $label );
						}
						else {
							$label->setAttribute( 'class',
								$label->getAttribute( 'class' ) . $add_label_classes );
							$container_div->appendChild( $label );

							//create a new div
							$bottom_line_div = $dom->createElement( 'div' );
							$bottom_line_div->setAttribute( 'class', 'mdc-line-ripple' );
							$container_div->appendChild( $bottom_line_div );
						}
					}
				}
			}
		}
	}


	$content = utf8_decode( $dom->saveHTML( $dom->documentElement ) );
}
