<?php

/***************************************** for dropdown inputs ****************************************************************************/
if ( in_array( $field->type, $select_fields ) ) {
	$dropdown_classes_types = array( 'ginput_container_select' );

	$divs = $dom->getElementsByTagName( 'div' );

	// $div_classes = $div->getAttribute( 'class' );

	// $div_classes_array = explode( ' ', $div_classes );
	$contains_error = false;
	foreach ( $divs as $div ) {
		$div_classes = $div->getAttribute( 'class' );
		if ( strpos( $div_classes, 'validation_message' ) !== false ) {
			$contains_error = true;
			$div->setAttribute( 'class', $div->getAttribute( 'class' ) . ' invalid-feedback' );
		}
	}

	foreach ( $divs as $div ) {
		$is_valid_input_field = false;
		$div_classes = $div->getAttribute( 'class' );
		$div_classes_array = explode( ' ', $div_classes );
		foreach ( $div_classes_array as $div_class_value ) {
			if ( in_array( $div_class_value, $dropdown_classes_types ) ) {
				$is_valid_input_field = true;
				$div->setAttribute( 'class', $div_classes. ' form-group' );
			}
		}

		if ( $is_valid_input_field ) {
			//add class to input
			$get_selects = $dom->getElementsByTagName( 'select' );
			foreach ( $get_selects as $get_select ) {
				$select_classes = $get_select->getAttribute( 'class' );
				$select_id = $get_select->getAttribute( 'id' );
				$select_classes .= ' form-control';
				if ( $contains_error ) {
					$select_classes .= ' is-invalid';
				}
				$get_select->setAttribute( 'class', $select_classes );
			}

			$content = utf8_decode( $dom->saveHTML( $dom->documentElement ) );
		}
	}




/***************************************** for time dropdown ****************************************************************************/

if ( $field->type === 'time' ) {
	$get_divs = $dom->getElementsByTagName( 'div' );
	foreach ( $get_divs as $div ) {
		$div_classes = $div->getAttribute( 'class' );
		if ( strpos( $div_classes, 'gfield_time_ampm' ) !== false ) {
			$div->setAttribute( 'class',
				$div->getAttribute( 'class' ) . '  form-group' );
			$get_selects = $div->getElementsByTagName( 'select' );
			foreach ( $get_selects as $select ) {
				$select->setAttribute( 'class',	$select->getAttribute( 'class' ) . '  form-control' );
					if ( $contains_error ) {
						$select->setAttribute( 'class',	$select->getAttribute( 'class' ) . '  is-invalid' );
					}
			}
		}
	}
	$content = utf8_decode( $dom->saveHTML( $dom->documentElement ) );
}

/***************************************** for address dropdown inputs ****************************************************************************/
if ( $field->type == 'address' ) {
	$allowed_address_fields = array( 'address_country', 'address_state' );
	$get_spans = $dom->getElementsByTagName( 'span' );
	$contains_error = false;
	foreach ( $get_spans as $get_span ) {
		$address_classes = $get_span->getAttribute( 'class' );
		$address_classes_array = explode( ' ', $address_classes );
		$is_allowed_field = false;
		foreach ( $address_classes_array as $address_class ) {
			if ( in_array( $address_class, $allowed_address_fields ) ) {
				$is_allowed_field = true;
			}
		}
		if ( $is_allowed_field ) {

			$all_divs = $dom->getElementsByTagName( 'div' );
			//create container div
			// $container_div = $dom->createElement( 'div' );
			// $container_div->setAttribute('class', 'mdc-text-field stla_material_large' );
			// $container_div->setAttribute( 'data-mdc-auto-init', 'MDCTextField' );

			foreach ( $all_divs as $current_div ) {
				$current_div_classes = $current_div->getAttribute( 'class' );
				if ( strpos( $current_div_classes, 'validation_message' ) !== false ) {
					$contains_error = true;
					//$current_div->setAttribute( 'class', $current_div->getAttribute( 'class' ) . ' mdc-text-field-helper-text mdc-text-field-helper-text--persistent mdc-text-field-helper-text--validation-msg' );
				}
			}

			$get_selects = $get_span->getElementsByTagName( 'select' );
			foreach ( $get_selects as $get_select ) {
				$span_classes = $get_span->getAttribute( 'class' );
				$span_classes .= '';
				// if ( $contains_error ) {
				// 	$span_classes .= ' mdc-text-field--invalid';
				// }
				$get_span->setAttribute( 'class', $span_classes );
				$select_classes = $get_select->getAttribute( 'class' ) . ' form-control';
				if($contains_error){
					$select_classes .= ' is-invalid';
				}

				$get_select->setAttribute( 'class', $select_classes );


			}
		}
	}


	$content = utf8_decode( $dom->saveHTML( $dom->documentElement ) );
}

/***************************************** for name prefix dropdown  ****************************************************************************/

if ( $field->type === 'name' ) {
	$get_spans = $dom->getElementsByTagName( 'span' );
	foreach ( $get_spans as $get_span ) {
		$span_classes = $get_span->getAttribute( 'class' );
		if ( strpos( $span_classes, 'name_prefix_select' ) !== false ) {

			$get_selects = $get_span->getElementsByTagName( 'select' );
			foreach( $get_selects as $get_select){
				$get_select->setAttribute( 'class',
				$get_select->getAttribute( 'class' ) . '  form-control' );
				if($contains_error){
					$get_select->setAttribute( 'class',
				$get_select->getAttribute( 'class' ) . '  is-invalid' );
				}

			}
		}
	}
	$content = utf8_decode( $dom->saveHTML( $dom->documentElement ) );
}

}