import * as React from '@wordpress/element';
import { createHigherOrderComponent } from '@wordpress/compose';
import { BlockControls } from '@wordpress/block-editor';
import { Toolbar } from '@wordpress/components';
import MergeTagSelector from './MergeTagSelector';
import { useFormId } from '../../hooks';

const MergeTagToolbar = createHigherOrderComponent( ( BlockEdit ) => {
	return ( props: any ) => {
		const formId = useFormId();

		if ( ! formId ) {
			return <BlockEdit { ...props } />;
		}

		return (
			<React.Fragment>
				<BlockEdit { ...props } />
				<BlockControls>
					<Toolbar>
						<MergeTagSelector formId={ formId } />
					</Toolbar>
				</BlockControls>
			</React.Fragment>
		);
	};
}, 'withInspectorControl' );

export default MergeTagToolbar;
