/**
 * WordPress provides React during the page load. This is for TypeScript type checking only.
 *
 * Importing React from @wordpress/element causes "Cannot read property 'createElement' of undefined"
 */
import React from 'react';
import { useBlockProps } from '@wordpress/block-editor';
import { __ } from '@wordpress/i18n';
import PaginationInspectorControls from './inspector-controls';

export interface PaginationAttributes {
	previousLabel: string;
	nextLabel: string;
	showNumbers: boolean;
	showNextPrevious: boolean;
}

/* eslint-disable jsx-a11y/anchor-is-valid */
const Edit = ( props: BlockProps<PaginationAttributes> ) => {
	const blockProps = useBlockProps();

	const nextLabel = props.attributes.nextLabel ? props.attributes.nextLabel : __( 'Next', 'gp-entry-blocks' );
	const previousLabel = props.attributes.previousLabel ? props.attributes.previousLabel : __( 'Previous', 'gp-entry-blocks' );

	return (
		<div { ...blockProps }>
			{
				props.attributes.showNextPrevious && (
					<div className="gpeb-pagination-prev">
						<a href="#">
							&larr; { previousLabel }
						</a>
					</div>

				)
			}

			{
				props.attributes.showNumbers && (
					<div className="gpeb-pagination-numbers">
						<a href="#">1</a>
						<a href="#">2</a>
						<span className="gpeb-pagination-current">3</span>
						<a href="#">4</a>
						<a href="#">5</a>
						<span className="gpeb-pagination-numbers-collapsed">…</span>
						<a href="#">16</a>
					</div>
				)
			}

			{
				props.attributes.showNextPrevious && (
					<div className="gpeb-pagination-next">
						<a href="#" style={ { float: 'right' } }>
							{ nextLabel } &rarr;
						</a>
					</div>
				)
			}
			<PaginationInspectorControls { ...props } />
		</div>
	);
};

/**
 * Blocks with dynamic PHP backends require that we only serialize the attributes.
 *
 * @see https://developer.wordpress.org/block-editor/tutorials/block-tutorial/creating-dynamic-blocks/
 */
const Save = () => {
	return null;
};

export const settings = {
	edit: Edit,
	save: Save,
};
