/**
 * WordPress provides React during the page load. This is for TypeScript type checking only.
 *
 * Importing React from @wordpress/element causes "Cannot read property 'createElement' of undefined"
 */
import { withSelect } from '@wordpress/data';
import {
	FiltersControl,
	FilterProperties,
	FiltersControlProps,
} from './FiltersControl/FiltersControl';

export default withSelect<
	{
		properties: FilterProperties;
	},
	FiltersControlProps
>( ( select, ownProps ) => {
	return {
		properties: select( 'gp-entry-blocks' ).getEntryProperties(
			ownProps.formId
		),
		getPropertyValues: ( propertyId: string ) =>
			select( 'gp-entry-blocks' ).getEntryPropertyValues(
				ownProps.formId,
				propertyId
			),
		propertyGroups: window.GPEB.entryFilterPropertyGroups,
	};
} )( FiltersControl );
