<?php

/***************************************** for checkbox ****************************************************************************/
if ( in_array( $field->type, $checkbox_fields ) ) {
	if ( ! isset( $material_options['checkbox-to-switch'] ) || $material_options['checkbox-to-switch'] === false  ) {


		$checkbox_classes_types = array( 'ginput_container_checkbox', 'ginput_container_consent' );

		$contains_error = false;

		$all_divs = $dom->getElementsByTagName( 'div' );
		foreach ( $all_divs as $current_div ) {
			$current_div_classes = $current_div->getAttribute( 'class' );
			if ( strpos( $current_div_classes, 'validation_message' ) !== false ) {
				$contains_error = true;
				$current_div->setAttribute( 'class', $current_div->getAttribute( 'class' ) . ' invalid-feedback' );
			}
		}


		foreach ( $all_divs as $div ) {
			$div_classes = $div->getAttribute( 'class' );
			$div_classes_array = explode( ' ', $div_classes );
			$is_valid_checkbox_field = false;

			foreach ( $div_classes_array as $div_class_value ) {
				if ( in_array( $div_class_value, $checkbox_classes_types ) ) {
					$is_valid_checkbox_field = true;
					
				}

				// for consent field
				if( "ginput_container_consent" === $div_class_value ) {
					$div->setAttribute( 'class', $div->getAttribute( 'class' ) . ' custom-control custom-checkbox' );
				}
			}

			
			
			if ( $is_valid_checkbox_field ) {
				$get_container = $dom->getElementsByTagName( 'li' );
				foreach ( $get_container as $container_element ) {
					$container_classes = $container_element->getAttribute( 'class' );
					if ( strpos( $container_classes, 'gchoice_' ) !== false ) {
						$container_element->setAttribute( 'class', $container_element->getAttribute( 'class' ) . ' custom-control custom-checkbox' );
					}
				}

				$get_inputs = $div->getElementsByTagName( 'input' );
				foreach ( $get_inputs as $input ) {
					$input->setAttribute( 'class',
						$input->getAttribute( 'class' ) . ' custom-control-input' );
						if ( $contains_error ) {
							$input->setAttribute( 'class',
						$input->getAttribute( 'class' ) . ' is-invalid' );
						}
				}

				$get_labels = $div->getElementsByTagName( 'label' );
				foreach ( $get_labels as $label ) {
					$label->setAttribute( 'class',
						$label->getAttribute( 'class' ) . ' custom-control-label' );
				}
				$content = utf8_decode( $dom->saveHTML( $dom->documentElement ) );
			}
		}
	}
}
