export {};

declare global {
    interface Window {
        ajaxurl: string
        GPEB: {
            ajaxUrl: string
            blockEditorXHRNonce: string
            canEditEntriesBlocks: boolean
            entryFilterPropertyGroups: { [propertyGroupId: string]: { label: string } }
			filterBlockUnsupportedInputTypes: string[]
        }
    }

    interface BlockProps<T, C = T> {
        category: string
        name: string
        parent?: string[]
        title: string
        attributes: { [attr in keyof T]: any },
        context: { [attr in keyof C]: any },
        setAttributes: (any) => any
        clientId: string
        children?: React.ReactNode
    }
}
