/**
 * @todo update me
 * Form select dropdown component to be used in inspector controls
 */

/**
 * WordPress provides React during the page load. This is for TypeScript type checking only.
 *
 * Importing React from @wordpress/element causes "Cannot read property 'createElement' of undefined"
 */
import React from 'react';

import { InspectorControls } from '@wordpress/block-editor';
import type { GPEntriesBlockAttributes } from './index';
import {
	PanelBody,
	BaseControl,
	SelectControl,
	TextControl,
} from '@wordpress/components';
import { useSelect } from '@wordpress/data';
import { __ } from '@wordpress/i18n';
import FormSelectControl from '../../components/controls-inspector/sidebar/FormSelectControl';
import { FilterPropertyControl } from '../../components/controls-inspector/sidebar/FiltersControl/FilterControl/FilterPropertyControl';
import EntryFiltersControl from '../../components/controls-inspector/sidebar/EntryFiltersControl';

import type {
	FilterProperties,
	FilterProperty,
} from '../../components/controls-inspector/sidebar/FiltersControl/FiltersControl';

function GPEBEntriesInspectorControls(
	props: BlockProps< GPEntriesBlockAttributes >
) {
	const properties: FilterProperties = useSelect(
		( select ) =>
			select( 'gp-entry-blocks' ).getEntryProperties(
				props.attributes.formId
			),
		[ props.attributes.formId ]
	);

	const orderbyProperties: FilterProperties = Object.fromEntries(
		Object.entries( properties )
			.filter( ( [ _, property ]: [string, FilterProperty] ) => property.orderby )
	);

	// @ts-ignore
	return (
		<InspectorControls>
			<PanelBody
				className="gpeb_panel_entries_settings"
				title={ __( 'Settings', 'gp-entry-blocks' ) }
				initialOpen={ ! props.attributes.formId }
			>
				<FormSelectControl { ...props } />

				<SelectControl
					id="mode"
					label={ __( 'Mode', 'gp-entry-blocks' ) }
					help={ __(
						'Specify how the inner blocks should behave. In "Multi-Entry" mode, the Edit Entry and View Entry blocks show when clicking Edit/View links. "View Single" and "Edit Single" modes will only show their respective blocks and the first returned entry based on the filters.',
						'gp-entry-blocks'
					) }
					options={ [
						{ value: 'multi-entry', label: __( 'Multi-Entry', 'gp-entry-blocks' ) },
						{ value: 'view-single', label: __( 'View Single', 'gp-entry-blocks' ) },
						{ value: 'edit-single', label: __( 'Edit Single', 'gp-entry-blocks' ) },
					] }
					value={ props.attributes.mode }
					onChange={ ( mode ) => props.setAttributes( { mode } ) }
				/>
			</PanelBody>

			<PanelBody
				className="gpeb_panel_entries_entry_query"
				title={ __( 'Entry Query', 'gp-entry-blocks' ) }
				initialOpen={ ! props.attributes.formId }
			>
				<EntryFiltersControl
					label={ __( 'Filters', 'gp-entry-blocks' ) }
					help={ __(
						'Filters used to determine which entries will be displayed.',
						'gp-entry-blocks'
					) }
					value={ props.attributes.filters }
					onChange={ ( filters ) =>
						props.setAttributes( { filters } )
					}
					formId={ props.attributes.formId }
				/>

				<BaseControl
					id="ordering"
					label={ __( 'Ordering', 'gp-entry-blocks' ) }
					className="gpeb_ordering_control"
				>
					<div className="gpeb_ordering_control_select_container">
						<FilterPropertyControl
							value={ props.attributes.orderBy }
							onChange={ ( orderBy ) =>
								props.setAttributes( { orderBy } )
							}
							properties={ orderbyProperties }
							propertyGroups={
								window.GPEB.entryFilterPropertyGroups
							}
						/>

						{ /* eslint-disable-next-line jsx-a11y/no-onchange */ }
						<select
							value={ props.attributes.order }
							onChange={ ( event ) =>
								props.setAttributes( {
									order: event.target.value,
								} )
							}
						>
							<option value="desc">{ __( 'Descending', 'gp-entry-blocks' ) }</option>
							<option value="asc">{ __( 'Ascending', 'gp-entry-blocks' ) }</option>
							<option value="rand">{ __( 'Random', 'gp-entry-blocks' ) }</option>
						</select>
					</div>
				</BaseControl>

				<TextControl
					id="limit"
					type="number"
					label={ __( 'Limit Per Page', 'gp-entry-blocks' ) }
					value={ props.attributes.limit }
					onChange={ ( limit ) => {
						const limitInt = parseInt( limit );
						props.setAttributes( { limit: isNaN( limitInt ) ? 0 : limitInt } );
					} }
				/>
			</PanelBody>
		</InspectorControls>
	);
}

export default GPEBEntriesInspectorControls;
