import { registerBlockType } from '@wordpress/blocks';
import { addFilter } from '@wordpress/hooks';

import { settings as entriesBlock } from './blocks/entries';
import { settings as entriesTableBlock } from './blocks/entries-table';
import { settings as entriesLoopBlock } from './blocks/entries-loop';
import { settings as paginationBlock } from './blocks/pagination';
import { settings as viewEntryBlock } from './blocks/view-entry';
import { settings as editEntryBlock } from './blocks/edit-entry';
import { settings as editFormBlock } from './blocks/edit-form';
import { settings as filtersBlock } from './blocks/filters';
import MergeTagToolbar from './components/controls-block/MergeTagToolbar';
import ViewSelectorToolbar from './components/controls-block/ViewSelectorToolbar';
import { appendMergeTagCompleter } from './autocompleters/mergeTagCompleter';

/**
 * Register store as a side-effect.
 */
import './stores/gpeb';

registerBlockType( 'gp-entry-blocks/entries', entriesBlock );
registerBlockType( 'gp-entry-blocks/entries-table', entriesTableBlock );
registerBlockType( 'gp-entry-blocks/entries-loop', entriesLoopBlock );
registerBlockType( 'gp-entry-blocks/pagination', paginationBlock );
registerBlockType( 'gp-entry-blocks/view-entry', viewEntryBlock );
registerBlockType( 'gp-entry-blocks/edit-entry', editEntryBlock );
registerBlockType( 'gp-entry-blocks/edit-form', editFormBlock );
registerBlockType( 'gp-entry-blocks/filters', filtersBlock );

/**
 * Add filters
 */
addFilter(
	'editor.BlockEdit',
	'gp-entry-blocks/merge-tag-toolbar',
	MergeTagToolbar
);

addFilter(
	'editor.BlockEdit',
	'gp-entry-blocks/view-selector-toolbar',
	ViewSelectorToolbar
);

addFilter(
	'editor.Autocomplete.completers',
	'gp-entry-blocks/autocompleters/merge-tags',
	appendMergeTagCompleter
);
