<?php

/*
 * Plugin Name: Custom Themes Gravity Forms
 * Plugin URI: https://wpmonks.com/downloads/custom-themes
 * Description: Save own themes for Gravity Forms
 * Author: Sushil Kumar
 * Author URI: https://wpmonks.com
 * Version: 2.0.1
 * License: GPLv2
 */

// don't load directly
if ( !defined( 'ABSPATH' ) ) die( '-1' );
//file to send automatic updates
include_once WP_PLUGIN_DIR . "/" . basename( dirname( __FILE__ ) ).'/update.php';
//set constants for plugin directory and plugin url
define( "GF_STLA_MY_THEME_DIR", WP_PLUGIN_DIR . "/" . basename( dirname( __FILE__ ) ) );
define( "GF_STLA_MY_THEME_URL", plugins_url() . "/" . basename( dirname( __FILE__ ) ) );

Class Gravity_Customizer_Save_Themes
	{
	public $old_theme = '';
	public $msg = '';
	public $new_theme = '';

	function __construct()
		{
		add_action('gf_stla_add_theme_section', array($this,'gf_stla_add_my_themes_section'	) , 13, 2);
		add_action('customize_save_after', array($this,'gf_stla_actions_after_saving'));
		$this->selected_form_id = get_option('gf_stla_select_form_id');
		add_action('wp_head', array($this,'gf_stla_preview_my_theme') , 12);
		add_action('customize_save', array($this,'gf_stla_get_old_my_theme'));
		add_action('customize_controls_enqueue_scripts', array($this,'hide_my_theme_section') , 11);

		add_action('admin_menu', array( $this, 'register_menu' ));
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );
        add_action('init', array( $this, 'add_headers' ));
		}

		public function admin_enqueue_scripts() {
			wp_enqueue_style( 'main_admin', GF_STLA_MY_THEME_URL . '/css/admin.css' );
		}

		public function add_headers() {
			// Exporting styles.
			if (isset( $_REQUEST[ 'stla_export_form' ] ) && $_REQUEST[ 'stla_export_form' ] && $_REQUEST[ 'stla_export_form' ] !== '-1') {
				$form_id = $_REQUEST[ 'stla_export_form' ];
	
				$form_styles = get_option("gf_stla_form_id_".$form_id);
				$form_styles['stla_export'] = true;
				$form_styles = json_encode($form_styles);
	
				header('Content-type: application/json');
				header('Content-Disposition: attachment; filename="gravity-forms-'.$form_id.'-styles.json"');
				header('Pragma: no-cache');
				header('Expires: 0');
				
				echo $form_styles;
				die();
			}
	
			// Importing styles
			if (isset($_REQUEST[ 'stla_import_form_select' ]) && $_REQUEST[ 'stla_import_form_select' ]) {
				$target_dir = wp_upload_dir() ;
				$target_file = $target_dir['basedir'] .'/stla-imports/'. basename($_FILES["stla-import-file"]["name"]);
				wp_mkdir_p( $target_dir['basedir'] .'/stla-imports/' );
	
				$uploadOk = 1;
				$imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
				// // Check if image file is a actual image or fake image
				// if (isset($_POST["submit"])) {
				//     $check = getimagesize($_FILES["fileToUpload"]["tmp_name"]);
				//     if ($check !== false) {
				//         echo "File is an image - " . $check["mime"] . ".";
				//         $uploadOk = 1;
				//     } else {
				//         echo "File is not an image.";
				//         $uploadOk = 0;
				//     }
				// }
	
				// Check file size
				if ($_FILES["stla-import-file"]["size"] > 500000) {
					$this->msg = '<tr id="row-stla-import-response" style="background-color:#ffc;">
										<th></th>
										<td>Sorry, your file is too large.</td>
									</tr>';
					$uploadOk = 0;
				}
				// Allow certain file formats
				if ($imageFileType != "json" ) {
					$this->msg = '<tr id="row-stla-import-response" style="background-color:#ffc;">
										<th></th>
										<td>Sorry, not a json file.</td>
									</tr>';
					$uploadOk = 0;
				}
				// Check if $uploadOk is set to 0 by an error
				if ($uploadOk === 1) {
					if (move_uploaded_file($_FILES["stla-import-file"]["tmp_name"], $target_file)) {
						// Read json file
						$form_styles = file_get_contents($target_dir['baseurl'] .'/stla-imports/'. basename($_FILES["stla-import-file"]["name"]) );
						$json = json_decode($form_styles, true); // decode the JSON into an associative array
						if( isset($json['stla_export']) ) {
							// Remove validation key
							unset($json['stla_export']);
	
							update_option("gf_stla_form_id_".$_REQUEST[ 'stla_import_form_select' ], $json );
							$this->msg = '<tr id="row-stla-import-response" style="background-color:#ffc;">
										<th></th>
										<td>Form Styles Imported Successfully. </td>
									</tr>';
						}
						
						else{
							$this->msg = '<tr id="row-stla-import-response-error" style="background-color:#ffc;color:red;">
										<th></th>
										<td>Not Valid Styles & Layouts export file </td>
									</tr>';
						}
					} else {
						$this->msg = '<tr id="row-stla-import-response-error" background-color:#ffc;color:red;">
							  <th></th>
							  <td>Sorry, there was an error uploading your file. </td>
						  </tr>';
					}
				}	
			}
			
	
		}

		public function register_menu() {
			add_submenu_page('stla_licenses', 'Import/Export', 'Import/Export', 'manage_options', 'stla-import-export', array( $this, 'import_export_callback' ));
		}

		public function import_export_callback() {
			$html = '<div id="stla_import_export_forms_import" class="postbox ">
			<h2 class="hndle stla-container-heading"><span>Import Form Styles</span></h2>
			<div class="inside">
			<div class="wrap stla-import-export-wrap">
			  <form action="" method="post" enctype="multipart/form-data">
				  <table class="form-table">
					  <tbody>'.$this->msg.'					  
						  <tr id="row_stla_import_form">
							  <th scope="row">
								  <label for="stla-import-file">Select a file</label>
							  </th>
							  <td>
								  <input type="file" id="stla-import-file" name="stla-import-file" class="widefat">
							  </td>
						  </tr>
						  <tr id="row-stla-import-type-error" style="display:none;color:red;">
							  <th></th>
							  <td>Please select a Ninja Forms export. <strong>Must be in .nff format</strong>.</td>
						  </tr>
							<tr id="row_stla_import_form_select">
								  <th scope="row">
									  <label for="stla_select_form_2">Select Form to Design</label>
								  </th>
								  <td >
									<select name="stla_import_form_select" id="stla_import_form_select" class="">
									';
			//get all gravity forms created by user
			if (class_exists('RGFormsModel')) {
				$forms = RGFormsModel::get_forms(null, 'title');
				foreach ($forms as $form) {
					$html .= '<option value="'.$form->id.'">'.$form->title.'</option>';
				}
			} else {
				$html .= '<option value="-1">Gravity Forms not installed</option>';
			}
			
			$html .=					'</select>
								  </td>
							  </tr>
	
						  <tr id="row_stla_import_form_submit">
							  <th scope="row">
								  <label for="stla-import-form-submit">Import Form</label>
							  </th>
							  <td>
							  <input type="submit" id="stla-import-form-submit" class="button-secondary" value="Import Form Styles">
							  </td>
						  </tr>
					  </tbody>
				  </table>
				</form>
			  </div></div>
			  </div>';
	
			  // Export Form Styles
			  $html .='<div id="stla_import_export_forms_export" class="postbox ">
			  <h2 class="hndle stla-container-heading"><span>Export Form Design</span></h2>
			  <div class="inside">
			  <div class="wrap stla-import-export-wrap">
			  <p>Only Forms which are designed using <strong>Styles & Layouts</strong> will show here.
				  <form action="" method="post">
			  
					  <table class="form-table">
						  <tbody>
							  <tr id="row_stla_export_form">
								  <th scope="row">
									  <label for="stla_export_form_2">Select a form</label>
								  </th>
								  <td >
									  <select name="stla_export_form" id="stla_export_form" class="">';
			//get all gravity forms created by user
			if (class_exists('RGFormsModel')) {
				$forms = RGFormsModel::get_forms(null, 'title');
				foreach ($forms as $form) {
					$form_styles = get_option("gf_stla_form_id_".$form->id);
					if (false !== $form_styles) {
						$html .= '<option value="'.$form->id.'">'.$form->title.'</option>';
					}
				}
			} else {
				$html .= '<option value="-1">Gravity Forms not installed</option>';
			}
		
			$html .=		  '</select>
								  </td>
							  </tr>
							
							  <tr id="row_stla_export_form_submit">
								  <th scope="row">
									  <label for="stla_export_form_submit">Export Form Styles</label>
								  </th>
								  <td>
									  <input type="submit" id="stla_export_form_submit" class="button-secondary" value="Export Form Styles">
								  </td>
							  </tr>
						  </tbody>
					  </table>
				  </form>
			  </div></div>
			  </div>';
	
			echo $html;
		}

//Add Custom Themes section and its settings
	function gf_stla_add_my_themes_section($wp_customize, $current_form_id)
		{
		$list_all_themes = ["none" => "None"];
		$list_delete_themes = ["none" => 'Select Theme to Delete'];
		$get_theme_names = get_option('list_saved_themes');

		//check if there are themes stored in database and merge them into array

		if (!empty($get_theme_names))
			{
				//array to show list in theme selection dropdown

			$list_all_themes = array_merge($list_all_themes, $get_theme_names);

				//array to show list in theme deletion dropdown

			$list_delete_themes = array_merge($list_delete_themes, $get_theme_names);
			}

			//if no theme is selected for current form then set it to none in database

		$set_selected_theme_database = get_option('gf_stla_form_id_my_selected_theme_' . $this->selected_form_id);
		if (empty($set_selected_theme_database))
			{
			update_option('gf_stla_form_id_my_selected_theme_' . $this->selected_form_id, 'none');
			}

			//Add Custom Themes section in customizer

		$wp_customize->add_section('gf_stla_form_id_my_themes', array(
			'title' => 'Custom Themes',
			'panel' => 'gf_stla_panel',
		));

		// settings to get theme names from database

		$wp_customize->add_setting('gf_stla_form_id_my_selected_theme_' . $this->selected_form_id, array(
			'default' => 'none',
			'type' => 'option'
		));

		$wp_customize->add_control('gf_stla_form_id_my_selected_theme_' . $this->selected_form_id, array(
			'type' => 'select',
			'priority' => 10, // Within the section.
			'section' => 'gf_stla_form_id_my_themes', // Required, core or custom.
			'label' => __('Saved Themes') ,
			'choices' => $list_all_themes,
		));

		// Apply Theme button

		$wp_customize->add_setting('gf_stla_form_id_apply_theme_button', array(
			'default' => 'Apply Theme',
			'transport' => 'postMessage',
			'type' => 'option'
		));

		$wp_customize->add_control('gf_stla_form_id_apply_theme_button', array(
			'type' => 'button',
			'priority' => 10, // Within the section.
			'section' => 'gf_stla_form_id_my_themes', // Required, core or custom.
			'input_attrs' => array(
				'style' => 'float:left',
				'class' => 'gf-stla-apply-theme-button'
			)
		));

		// Dropdown to delete themes

		$wp_customize->add_setting('gf_stla_form_id_my_delete_theme', array(
			'default' => 'none',
			'transport' => 'postMessage',
			'type' => 'option'
		));

		$wp_customize->add_control('gf_stla_form_id_my_delete_theme', array(
			'type' => 'select',
			'priority' => 10, // Within the section.
			'section' => 'gf_stla_form_id_my_themes', // Required, core or custom.
			'label' => __('Select a Theme to Delete') ,
			'choices' => $list_delete_themes,
		));

		// Delete Theme button

		$wp_customize->add_setting('gf_stla_form_id_delete_theme_button', array(
			'default' => 'Delete Theme',
			'transport' => 'postMessage',
			'type' => 'option'
		));

		$wp_customize->add_control('gf_stla_form_id_delete_theme_button', array(
			'type' => 'button',
			'priority' => 10, // Within the section.
			'section' => 'gf_stla_form_id_my_themes', // Required, core or custom.
			'input_attrs' => array(
				'style' => 'float:left',
				'class' => 'gf-stla-delete-theme-button'
			)
		));

		//Control and setting to save new theme

		$wp_customize->add_setting('gf_stla_form_id_saved_theme_name', array(
			'default' => '',
			'transport' => 'postMessage',
			'type' => 'option'
		));

		$wp_customize->add_control('gf_stla_form_id_saved_theme_name', array(
			'type' => 'text',
			'priority' => 10, // Within the section.
			'section' => 'gf_stla_form_id_my_themes', // Required, core or custom.
			'label' => __('Name for New Theme') ,
			'input_attrs' => array(
				'placeholder' => 'Enter desired theme name'			
			)
		));

		// save theme button

		$wp_customize->add_setting('gf_stla_form_id_saved_theme_button', array(
			'default' => 'Save Theme',
			'transport' => 'postMessage',
			'type' => 'option'
		));

		$wp_customize->add_control('gf_stla_form_id_saved_theme_button', array(
			'type' => 'button',
			'priority' => 10, // Within the section.
			'section' => 'gf_stla_form_id_my_themes', // Required, core or custom.
			'input_attrs' => array(
				'class' => 'gf-stla-save-theme-button'
			)
		));
		}

	function gf_stla_actions_after_saving()
		{

		// To save new theme name in database

		$new_theme_name = get_option('gf_stla_form_id_saved_theme_name');
		if (!empty($new_theme_name) && $new_theme_name != 'none')
			{
			$new_theme_key = str_replace(' ', '_', $new_theme_name);
			$list_saved_themes = get_option('list_saved_themes');
			$list_saved_themes[$new_theme_key] = $new_theme_name;
			update_option('list_saved_themes', $list_saved_themes);
			$theme_to_save = get_option('gf_stla_form_id_' . $this->selected_form_id);
			update_option('gf_stla_form_id_' . $new_theme_key, $theme_to_save);
			delete_option('gf_stla_form_id_saved_theme_name');
			}

		// Whether or not to apply the theme

		$this->new_theme = get_option('gf_stla_form_id_my_selected_theme_' . $this->selected_form_id);
		if ($this->new_theme != $this->old_theme)
			{
			$theme_to_copy = get_option('gf_stla_form_id_' . $this->new_theme);
			update_option('gf_stla_form_id_' . $this->selected_form_id, $theme_to_copy);
			}

		//theme applied on current form

			$current_theme = get_option('gf_stla_form_id_my_selected_theme_' . $this->selected_form_id);

			//array of current form style

			$current_form_array = get_option('gf_stla_form_id_'.$this->selected_form_id);

			//array of current theme

			$current_theme_array = get_option('gf_stla_form_id_'.$current_theme);
			
			//compare theme and form arrays and set to none if they are not equal

			if($current_form_array !== $current_theme_array){

				update_option('gf_stla_form_id_my_selected_theme_' . $this->selected_form_id, 'none');

			}

		// Delete a theme

		$theme_to_delete = get_option('gf_stla_form_id_my_delete_theme');
		if (!empty($theme_to_delete) && $theme_to_delete != 'none')
			{

			// Get list of all saved themes

			$list_saved_themes = get_option('list_saved_themes');

			// Remove all theme data from database

			delete_option('gf_stla_form_id_' . $theme_to_delete);

			// remove theme from list of themes array

			unset($list_saved_themes[$theme_to_delete]);

			// update theme list database

			update_option('list_saved_themes', $list_saved_themes);

			// remove delete theme setting from database

			update_option('gf_stla_form_id_my_delete_theme', 'none');
			}
		}
//preview selected theme

	function gf_stla_preview_my_theme()
		{
		
		if (!empty($this->selected_form_id))
			{
			$css_form_id = get_option('gf_stla_form_id_my_selected_theme_' . $this->selected_form_id);
			if (!empty($css_form_id) && $css_form_id != 'none')
				{
				$selected_form = $this->selected_form_id;
				$is_customizer_open = is_customize_preview();
				if (class_exists('Gravity_customizer_admin') && $is_customizer_open)
					{
					$main_class_object = new Gravity_customizer_admin();
					include 'display/class-styles.php';

					}
				}
			}
		}

//get saved theme
	function gf_stla_get_old_my_theme()
		{
		$this->old_theme = get_option('gf_stla_form_id_my_selected_theme_' . $this->selected_form_id);
		}

//jquery to hide my theme section and automatically save and refresh page

	function hide_my_theme_section()
		{
		wp_enqueue_script('gf_stla_hide_my_theme_section', GF_STLA_MY_THEME_URL . '/js/hide-my-theme-section.js', array('jquery') , '', true);
		wp_enqueue_style( 'theme-customizer-css', GF_STLA_MY_THEME_URL . '/css/customizer-controls.css' );
		}
	} //class ends here

add_action('plugins_loaded', 'gravity_customizer_save_themes');

function gravity_customizer_save_themes()
{
	new Gravity_Customizer_Save_Themes();
}


