<?php
/**
 * text input type
 */
class GravityView_FieldType_text extends GravityView_FieldType {
	function render_setting( $override_input = null ) {
		if ( ! empty( $this->field['full_width'] ) ) { ?>
			<th scope="row" colspan="2">
				<div>
					<?php $this->render_option(); ?>
				</div>
			</th>
		<?php } else {
			parent::render_setting( $override_input );
		}
	}

	function render_option() {
		?>
		<label for="<?php echo $this->get_field_id(); ?>" class="<?php echo $this->get_label_class(); ?>">
								<?php

								echo $this->get_field_label() . $this->get_tooltip() . $this->get_field_desc();
								?>
		<div>
				<?php $this->render_input(); ?>
			</div>
		</label>
		<?php
	}

	function render_input( $override_input = null ) {

		if ( isset( $override_input ) ) {
			echo $override_input;
			return;
		}

		$class = '';

		$show_mt = $this->show_merge_tags();

		if ( $show_mt && false !== $this->field['merge_tags'] || 'force' === $this->field['merge_tags'] ) {
			$class = 'gv-merge-tag-support mt-position-right mt-hide_all_fields ';
		}
		$class      .= \GV\Utils::get( $this->field, 'class', 'widefat' );
		$placeholder = \GV\Utils::get( $this->field, 'placeholder' );
		?>
		<input name="<?php echo esc_attr( $this->name ); ?>" placeholder="<?php echo esc_attr( $placeholder ); ?>" id="<?php echo $this->get_field_id(); ?>" type="text" value="<?php echo esc_attr( $this->value ); ?>" class="<?php echo esc_attr( $class ); ?>">
		<?php
	}
}



