/**
 * WordPress provides React during the page load. This is for TypeScript type checking only.
 *
 * Importing React from @wordpress/element causes "Cannot read property 'createElement' of undefined"
 */
import React from 'react';

import { InspectorControls } from '@wordpress/block-editor';
import { PanelBody, TextareaControl } from '@wordpress/components';
import { __ } from '@wordpress/i18n';
import { EditFormAttributes } from './index';

export default function EditFormInspectorControls(
	props: BlockProps< EditFormAttributes >
) {
	return (
		<InspectorControls>
			<PanelBody
				className="gpeb_panel_edit_form_messages"
				title={ __( 'Messages', 'gp-entry-blocks' ) }
			>
				<TextareaControl
					value={ props.attributes.confirmationMessage }
					onChange={ ( confirmationMessage ) =>
						props.setAttributes( { confirmationMessage } )
					}
					label={ __( 'Edit Confirmation', 'gp-entry-blocks' ) }
				/>
			</PanelBody>
		</InspectorControls>
	);
}
