<?php

/*
 * Plugin Name: Gravity Forms Tooltips
 * Plugin URI: https://wpmonks.com/downloads/tooltips
 * Description: Show tooltips in Gravity Forms
 * Author: Sushil Kumar
 * Author URI: https://wpmonks.com
 * Version: 1.5.4
 * License: GPLv2
 */
// don't load directly
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}
// file to send automatic updates
require_once WP_PLUGIN_DIR . '/' . basename( dirname( __FILE__ ) ) . '/update.php';
// set constants for plugin directory and plugin url
define( 'GF_STLA_TOOLTIPS_DIR', WP_PLUGIN_DIR . '/' . basename( dirname( __FILE__ ) ) );
define( 'GF_STLA_TOOLTIPS_URL', plugins_url() . '/' . basename( dirname( __FILE__ ) ) );
define( 'GF_STLA_TOOLTIPS_VERSION', '1.5.4' );

class Gf_Stla_Tooltips_Addon {


	function __construct() {
		add_action( 'gf_stla_add_theme_section', array( $this, 'gf_stla_add_tooltips_section' ), 14, 2 );
		add_filter( 'gform_field_content', array( $this, 'gf_stla_add_tooltips_class' ), 10, 2 );
		add_action( 'gform_enqueue_scripts', array( $this, 'gf_stla_add_tooltips_css_js' ), 10, 2 );
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'gf_stla_hide_tooltips_js' ) );

	} //constructor ends here

	/** Hide tooltips section until a form is selected */
	function gf_stla_hide_tooltips_js() {
		$current_form_id = get_option( 'gf_stla_select_form_id' );
		wp_enqueue_style( 'tooltip-customizer-css', GF_STLA_TOOLTIPS_URL . '/css/customizer-controls.css', array(), GF_STLA_TOOLTIPS_VERSION );
		wp_enqueue_script( 'hide_tooltips_section', GF_STLA_TOOLTIPS_URL . '/js/hide-tooltips.js', array( 'jquery' ), GF_STLA_TOOLTIPS_VERSION, true );
		wp_enqueue_script( 'customizer_control_script', GF_STLA_TOOLTIPS_URL . '/js/customizer-control/customizer-control.js', array( 'jquery' ), GF_STLA_TOOLTIPS_VERSION, true );
		wp_localize_script( 'customizer_control_script', 'gf_stla_localize_current_form', array( 'formId' =>  $current_form_id ) );
	}

	/** Create global javascript variables for activation js and set default values for activation js */
	function gf_stla_add_tooltips_css_js( $form, $is_ajax ) {

		// is_admin doesn't work in gutenberg. used REST_REQUEST for this
		if ( is_admin() || defined( 'REST_REQUEST' ) ) {
			return;
		 }
		
		$current_form = get_option( 'gf_stla_form_id_tooltips_' . $form['id'] );
		// load tooltips js and css only if tooltips are set for the form on the page
		if ( ! empty( $current_form ) ) {

			$tooltip_settings['enabled']   = isset( $current_form['tooltips']['enabled'] ) ? $current_form['tooltips']['enabled'] : true;
			$tooltip_settings['theme']     = isset( $current_form['tooltips']['tooltip-theme'] ) ? $current_form['tooltips']['tooltip-theme'] : 'default';
			$tooltip_settings['animation'] = isset( $current_form['tooltips']['tooltip-animation'] ) ? $current_form['tooltips']['tooltip-animation'] : 'shift-away';
			$tooltip_settings['position']  = isset( $current_form['tooltips']['tooltip-position'] ) ? $current_form['tooltips']['tooltip-position'] : 'top';
			$tooltip_settings['maxWidth']  = isset( $current_form['tooltips']['max-width'] ) ? $this-> gf_tooltip_add_px_to_value($current_form['tooltips']['max-width']) : 'auto';
			$tooltip_settings['formId']    = $form['id'];

			if ( $tooltip_settings['enabled'] == true ) {
				wp_enqueue_style( 'gf_stla_tooltips_animations', GF_STLA_TOOLTIPS_URL . '/css/animations.css', array(), GF_STLA_TOOLTIPS_VERSION );
				wp_enqueue_style( 'gf_stla_tooltips_themes', GF_STLA_TOOLTIPS_URL . '/css/tippy-themes.css', array(), GF_STLA_TOOLTIPS_VERSION );
				wp_enqueue_style( 'tooltip-custom-css', GF_STLA_TOOLTIPS_URL . '/css/custom.css', array(), GF_STLA_TOOLTIPS_VERSION );
				wp_enqueue_script( 'gf_stla_popper_js', GF_STLA_TOOLTIPS_URL . '/js/popper.min.js', array( 'jquery' ), GF_STLA_TOOLTIPS_VERSION, true );
				wp_enqueue_script( 'gf_stla_tooltips_js', GF_STLA_TOOLTIPS_URL . '/js/tippy.min.js', array( 'gf_stla_popper_js' ), GF_STLA_TOOLTIPS_VERSION, true );

				

				// add $current form values into javascript variable and then call the activation js file

				wp_enqueue_script( 'gf_stla_tooltips_activation', GF_STLA_TOOLTIPS_URL . '/js/tooltips-activation.js', array( 'jquery' ), GF_STLA_TOOLTIPS_VERSION, true );
				wp_localize_script( 'gf_stla_tooltips_activation', 'stla_tooltips_localize_'.$form['id'], array( 'settings' => $tooltip_settings ) );
				include 'display/styles.php';

			}
		}
	}
	/** Add Tooltips section and settings in customizer */
	function gf_stla_add_tooltips_section( $wp_customize, $current_form_id ) {

		if ( ! class_exists( 'RGFormsModel' ) ) {
			return;
		}

		$this->selected_form_id = $current_form_id;
		$this->get_form_fields = RGFormsModel::get_form_meta( $this->selected_form_id );

		$icon_size         = array(
			'9'  => '9px',
			'10' => '10px',
			'11' => '11px',
			'12' => '12px',
			'13' => '13px',
			'14' => '14px',
			'15' => '15px',
			'16' => '16px',
			'17' => '17px',
			'18' => '18px',
			'19' => '19px',
			'20' => '20px',
			'21' => '21px',
			'22' => '22px',
			'23' => '23px',
			'24' => '24px',
		);
		$icon_type         = array(
			'icon1' => 'Icon 1',
			'icon2' => 'Icon 2',
			'icon3' => 'Icon 3',
			'icon4' => 'Icon 4',
			'icon5' => 'Icon 5',
			'icon6' => 'Icon 6',
			'icon7' => 'Icon 7',
			'icon8' => 'Icon 8',
			'icon9' => 'Icon 9',
		);
		$tooltip_theme     = array(
			'default'    => 'Default',
			'light'      => 'Light',
			'borderless' => 'Borderless',
			'punk'       => 'Punk',
			'noir'       => 'Noir',
			'shadow'     => 'Shadow',
			'custom-'.$current_form_id     => 'Custom'
		);
		$tooltip_animation = array(
			'shift-away'   => 'Shift Away',
			'shift-toward' => 'Shift Toward',
			'fade'         => 'Fade',
			'scale'        => 'Scale',
			'perspective'  => 'Perspective',
		);
		$tooltip_position  = array(
			'top'    => 'Top',
			'bottom' => 'Bottom',
			'right'  => 'Right',
			'left'   => 'Left',
		);

		// Add Tooltips section
		$wp_customize->add_section(
			'gf_stla_form_id_tooltips',
			array(
				'title' => 'Tooltips',
				'panel' => 'gf_stla_panel',
			)
		);

		// Enable Tooltips
		$wp_customize->add_setting(
			'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][enabled]',
			array(
				'default' => '1',
				// 'transport'   => 'postMessage',
				'type'    => 'option',
			)
		);

		$wp_customize->add_control(
			'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][enabled]',
			array(
				'type'     => 'checkbox',
				'priority' => 10, // Within the section.
				'section'  => 'gf_stla_form_id_tooltips', // Required, core or custom.
				'label'    => __( 'Enable Tooltips' ),

			)
		);

		// icon type
		$wp_customize->add_setting(
			'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][icon-type]',
			array(
				'default' => 'icon1',
				// 'transport'   => 'postMessage',
				'type'    => 'option',
			)
		);

		$wp_customize->add_control(
			'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][icon-type]',
			array(
				'type'     => 'select',
				'priority' => 10, // Within the section.
				'section'  => 'gf_stla_form_id_tooltips', // Required, core or custom.
				'label'    => __( 'Icon Type' ),
				'choices'  => $icon_type,
			)
		);

		// icon size option
		$wp_customize->add_setting(
			'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][icon-size]',
			array(
				'default' => '14',
				// 'transport'   => 'postMessage',
				'type'    => 'option',
			)
		);

		$wp_customize->add_control(
			'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][icon-size]',
			array(
				'type'     => 'select',
				'priority' => 10, // Within the section.
				'section' => 'gf_stla_form_id_tooltips', // Required, core or custom.
				'label' => __( 'Icon Size' ),
				'choices' => $icon_size
			) );
			
			//tooltip font size option
			$wp_customize->add_setting( 'gf_stla_form_id_tooltips_'.$current_form_id.'[tooltips][font-size]' , array(
				'default'     => '14',
				//'transport'   => 'postMessage',
				'type' => 'option'
			) );

		$wp_customize->add_control( 'gf_stla_form_id_tooltips_'.$current_form_id.'[tooltips][font-size]',   array(
				'type' => 'text',
				'priority' => 10, // Within the section.
				'section' => 'gf_stla_form_id_tooltips', // Required, core or custom.
				'label' => __( 'Tooltip Font Size' ),
				'input_attrs' => array(
					'placeholder' => 'Ex: 10px'
				)
			) );

		// Icon margin top option
		$wp_customize->add_setting(
			'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][margin-top]',
			array(
				'default' => '-2px',
				// 'transport'   => 'postMessage',
				'type'    => 'option',
			)
		);

		$wp_customize->add_control(
			'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][margin-top]',
			array(
				'type'     => 'text',
				'priority' => 10, // Within the section.
				'section'  => 'gf_stla_form_id_tooltips', // Required, core or custom.
				'label'    => __( 'Icon Top Margin' ),

			)
		);
		// Icon margin top option
		$wp_customize->add_setting(
			'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][margin-left]',
			array(
				'default' => '4px',
				// 'transport'   => 'postMessage',
				'type'    => 'option',
			)
		);

		$wp_customize->add_control(
			'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][margin-left]',
			array(
				'type'        => 'text',
				'priority'    => 10, // Within the section.
				'section'     => 'gf_stla_form_id_tooltips', // Required, core or custom.
				'label'       => __( 'Icon Left Margin' ),
				'input_attrs' => array(
					'placeholder' => 'Example: 10px',
				),
			)
		);

		// Tooltip's animation
		$wp_customize->add_setting(
			'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][tooltip-animation]',
			array(
				'default' => 'fade',
				// 'transport'   => 'postMessage',
				'type'    => 'option',
			)
		);

		$wp_customize->add_control(
			'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][tooltip-animation]',
			array(
				'type'     => 'select',
				'priority' => 10, // Within the section.
				'section'  => 'gf_stla_form_id_tooltips', // Required, core or custom.
				'label'    => __( 'Tooltip Animation' ),
				'choices'  => $tooltip_animation,
			)
		);
		// Tooltip's position
		$wp_customize->add_setting(
			'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][tooltip-position]',
			array(
				'default' => 'top',
				// 'transport'   => 'postMessage',
				'type'    => 'option',
			)
		);

		$wp_customize->add_control(
			'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][tooltip-position]',
			array(
				'type'     => 'select',
				'priority' => 10, // Within the section.
				'section'  => 'gf_stla_form_id_tooltips', // Required, core or custom.
				'label'    => __( 'Tooltip Position' ),
				'choices'  => $tooltip_position,
			)
		);

		// Tooltip's Maximum Width.
		$wp_customize->add_setting(
			'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][max-width]',
			array(
				'default' => '',
				'type'    => 'option',
			)
		);

		$wp_customize->add_control(
			'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][max-width]',
			array(
				'type'        => 'text',
				'priority'    => 10, // Within the section.
				'section'     => 'gf_stla_form_id_tooltips', // Required, core or custom.
				'label'       => __( 'Tooltip Maximum Width' ),
				'input_attrs' => array(
					'placeholder' => 'Ex: 70px',
				),
			)
		);
			// Tooltip's theme
			$wp_customize->add_setting(
				'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][tooltip-theme]',
				array(
					'default' => 'default',
					'type'    => 'option',
				)
			);
	
			$wp_customize->add_control(
				'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][tooltip-theme]',
				array(
					'type'     => 'select',
					'priority' => 10, // Within the section.
					'section'  => 'gf_stla_form_id_tooltips', // Required, core or custom.
					'label'    => __( 'Tooltip Theme' ),
					'choices'  => $tooltip_theme,
				)
			);
		// Tooltip Background color.
		$background_control_id = 'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][background-color]';
		$this->gf_custom_color_setting( $wp_customize, 'gf_stla_form_id_tooltips', $background_control_id, 'Tooltip background color' );

		// Tooltip description font-size.
		$font_size_control_id = 'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][font-size]';
		$this->gf_field_setting_control( $wp_customize, 'gf_stla_form_id_tooltips', 'text', $font_size_control_id, 'font size', '', 'Ex: 18px', '' );
		// Tooltip font color.
		$font_color_control_id = 'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][font-color]';
		$this->gf_custom_color_setting( $wp_customize, 'gf_stla_form_id_tooltips', $font_color_control_id, 'Tooltip font color' );
		// Border size.
		$border_size_control_id = 'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][border-size]';
		$this->gf_field_setting_control( $wp_customize, 'gf_stla_form_id_tooltips', 'text', $border_size_control_id, 'Border size', '', 'Ex: 4px', '' );

		// Border type.
		// $border_type_control_id = 'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][border-type]';
		// $this->gf_field_setting_control( $wp_customize, 'gf_stla_form_id_tooltips', 'select', $border_type_control_id, 'Border type', $border_types, 'default', 'none' );

		// Border radius.
		$border_radius_control_id = 'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][border-radius]';
		$this->gf_field_setting_control( $wp_customize, 'gf_stla_form_id_tooltips', 'text', $border_radius_control_id, 'Border radius', '', 'Ex: 20px', '' );

		// Tooltip Background color.
		$border_color_control_id = 'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][border-color]';
		$this->gf_custom_color_setting( $wp_customize, 'gf_stla_form_id_tooltips', $border_color_control_id, 'Tooltip border color' );

		// Tooltip Background color.
		$arrow_color_control_id = 'gf_stla_form_id_tooltips_' . $current_form_id . '[tooltips][arrow-color]';
		$this->gf_custom_color_setting( $wp_customize, 'gf_stla_form_id_tooltips', $arrow_color_control_id, 'Tooltip Arrow color' );

		
		// Fields of form. get value of 0 when no form i selected.
		$field_count       = is_array( $this->get_form_fields['fields'] ) ? count( $this->get_form_fields['fields'] ): 0;

		for ( $i = 0; $i < $field_count; $i++ ) {
			$field_object  = $this->get_form_fields['fields'][ $i ];
			$control_id    = 'gf_stla_form_id_tooltips_' . $current_form_id . '[' . $field_object->id . '][message]';
			$control_label = $field_object->label . ' Tooltip';
			$this->gf_field_setting_control( $wp_customize, 'gf_stla_form_id_tooltips', 'textarea', $control_id, $control_label, '', '', '' );

			$allowed_choice_fields = array( 'checkbox', 'radio', 'product', 'option', 'shipping' );
			$allowed_input_types = array( 'checkbox', 'radio' );
			
			if( in_array( $field_object['type'], $allowed_choice_fields) && ( empty( $field_object['inputType'] )  || in_array( $field_object['inputType'], $allowed_input_types ) ) ) {
			
				$choices = $field_object['choices'];
				$counter = 0;
				foreach ( $choices as $choice ) {
					$control_id  = 'gf_stla_form_id_tooltips_' . $current_form_id . '[' . $field_object->id . '][' . $counter . '][message]';
					$field_label = $choice['text'] . ' Tooltip';
					$this->gf_field_setting_control( $wp_customize, 'gf_stla_form_id_tooltips', 'textarea', $control_id, $field_label, '', '', '' );
					$counter++;
				}
			}
		}
	}


	/**
	 * Creating control and setting for GF fields.
	 *
	 * @param [object] $wp_customize WordPress customizer object for setting and control.
	 * @param [string] $section Section name of Control.
	 * @param [string] $type Type of field.
	 * @param [string] $control_id  Id for settings and control.
	 * @param [string] $control_label basic label of control.
	 * @param [string] $control_choice choices for select field.
	 * @return void
	 */
	public function gf_field_setting_control( $wp_customize, $section, $type, $control_id, $control_label, $control_choice, $placeholder, $default_value ) {
		$wp_customize->add_setting(
			$control_id,
			array(
				'default' => $default_value,
				'type'    => 'option',
			)
		);

		$wp_customize->add_control(
			$control_id,
			array(
				'type'     => $type,
				'priority' => 10, // Within the section.
				'section'  => $section, // Required, core or custom.
				'label'    => $control_label,
				'choices'   => $control_choice,
				'input_attrs' => array(
					'placeholder' => $placeholder,
				),

			)
		);

	}
	public function gf_custom_color_setting( $wp_customize, $section, $control_id, $control_label ){

		$wp_customize->add_setting(
			$control_id,
			array(
				'default'   => '',
				'type'      => 'option',
			)
		);
		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize, // WP_Customize_Manager.
				$control_id, // Setting id.
				array( // Args, including any custom ones.
					'label'   => $control_label,
					'section' => $section,
				)
			)
		);
	}
	function gf_stla_add_tooltips_class( $field_content, $field ) {
		
		// is_admin doesn't work in gutenberg. used REST_REQUEST for this
		if ( is_admin() || defined( 'REST_REQUEST' ) ) {
			return $field_content;
		 }

		$current_form = get_option( 'gf_stla_form_id_tooltips_' . $field->formId );
		if ( ! empty( $current_form ) ) {

			$current_form['tooltips']['enabled']     = isset( $current_form['tooltips']['enabled'] ) ? $current_form['tooltips']['enabled'] : true;
			$current_form['tooltips']['icon-size']   = isset( $current_form['tooltips']['icon-size'] ) ? $current_form['tooltips']['icon-size'] : '14';
			$current_form['tooltips']['margin-top']  = isset( $current_form['tooltips']['margin-top'] ) ? $this->gf_tooltip_add_px_to_value( $current_form['tooltips']['margin-top'] ) : '-2px';
			$current_form['tooltips']['icon-type']   = isset( $current_form['tooltips']['icon-type'] ) ? $current_form['tooltips']['icon-type'] : 'icon1';
			$current_form['tooltips']['margin-left'] = isset( $current_form['tooltips']['margin-left'] ) ? $this->gf_tooltip_add_px_to_value( $current_form['tooltips']['margin-left'] ) : '4px';
			// print_r($field->type);
			if ( $current_form['tooltips']['enabled'] == true && ! is_admin() && isset( $current_form[ $field->id ] ) && ! empty( $current_form[ $field->id ] ) ) {
				// Checking field type
				$allowed_choice_fields = array( 'checkbox', 'radio', 'product', 'option', 'shipping' );
				$allowed_input_types = array( 'checkbox', 'radio' );
				
				if( in_array( $field['type'], $allowed_choice_fields) && ( empty( $field['inputType'] )  || in_array( $field['inputType'], $allowed_input_types ) ) ) {
						$explode_string = '</label></li>';
						$field_content = $this->add_tooltip_after_choices( $current_form, $field, $field_content, $explode_string );		
				}

				if ( 'list' === $field->type ) {
					$explode_string = '</th>';
					$field_content = $this->add_tooltip_after_choices( $current_form, $field, $field_content, $explode_string );
				}
				if ( ! empty( $current_form[ $field->id ]['message'] ) ) {
					$pos     = strpos( $field_content, '</label>' );
					$replace = '<img style="display:inline-block; width:' . $current_form['tooltips']['icon-size'] . 'px; margin-top:' . $current_form['tooltips']['margin-top'] . '; margin-left:' . $current_form['tooltips']['margin-left'] . ';" src="' . GF_STLA_TOOLTIPS_URL . '/images/' . $current_form['tooltips']['icon-type'] . '.png" data-tippy-content="' . esc_html( $current_form[ $field->id ]['message'] ) . '"/></label>';
					$needle  = '</label>';

					if ( $pos !== false ) {

						$newstring = substr_replace( $field_content, $replace, $pos, strlen( $needle ) );
						return $newstring;
					}

					if ( $field->type == 'section' ) {

						return str_replace( '</h2>', '<img style="display:inline-block; width:' . $current_form['tooltips']['icon-size'] . 'px; margin-top:' . $current_form['tooltips']['margin-top'] . '; margin-left:' . $current_form['tooltips']['margin-left'] . ';" src="' . GF_STLA_TOOLTIPS_URL . '/images/' . $current_form['tooltips']['icon-type'] . '.png" data-tippy-content="' . esc_html( $current_form[ $field->id ]['message'] ) . '"/> </h2> ', $field_content );
					}
				}
			}
		}
		return $field_content;
	}

	function add_tooltip_after_choices( $current_form, $field, $field_content, $explode_string ) {
	
		 // remove multiple spaces and line breaks
		 $field_content = trim(preg_replace('/>\s+</', '><', $field_content));
		 //$field_content = trim(preg_replace('/>\s</', '><', $field_content));

		$choices_tooltip = $current_form[ $field->id ];

		// explode() splits HTML string into array form </li> and removed </li> from string.
		$explode_choices      = explode( $explode_string, $field_content );
		$str                   = '';
		$counter               = 0;
		$choices_size = count( $explode_choices );
		// Loop though array from 0 to 2nd last position.
		for ( $i = 0; $i < $choices_size - 1; $i++ ) {
			// first array element added into str variable then check if tooltip value in not empty.
			$str .= $explode_choices[ $i ];
			if ( ! empty( $choices_tooltip[ $counter ]['message'] ) ) {

				// img added in $str and ended with </li>.
				$str .= '<img style="display:inline-block; width:' . $current_form['tooltips']['icon-size'] . 'px; margin-top:' . $current_form['tooltips']['margin-top'] . '; margin-left:' . $current_form['tooltips']['margin-left'] . ';" src="' . GF_STLA_TOOLTIPS_URL . '/images/' . $current_form['tooltips']['icon-type'] . '.png" data-tippy-content="' . esc_html( $choices_tooltip[ $counter ]['message'] ) . '"/>' . $explode_string;
			} else {
				// if tooltip value is empty just added </li> at last of string.
				$str .= $explode_string;
			}
			$counter++;
		}
		
		// add last element of array (</ul></div>) into str.
		$str = $str . $explode_choices[ $choices_size - 1 ];

		// final $str added into $field_content.
		$field_content = $str;

		return $field_content;
	}

// funciton to show px after value.
	public function gf_tooltip_add_px_to_value( $value ) {
		$int_parsed = (int) $value;
		if ( is_numeric( $value ) ) {
			$value .= 'px';
		} else {
			$value .= '';
		}
		return $value;
	}

} //class ends here

add_action( 'plugins_loaded', 'gf_stla_tooltips_addon' );

function gf_stla_tooltips_addon() {
	new Gf_Stla_Tooltips_Addon();
}


