<?php

if ( in_array( $field->type, $this->input_fields ) ) {
	$input_classes_types = array( 'ginput_container_date', 'ginput_container_text', 'ginput_container_phone', 'ginput_container_email', 'ginput_container_website', 'ginput_container_post_title', 'ginput_container_number', 'ginput_container_post_tags' );
	$all_divs = $dom->getElementsByTagName( 'div' );
	
	foreach ( $all_divs as $div ) {
		
		$div_classes = $div->getAttribute( 'class' );
		$div_classes_array = explode( ' ', $div_classes );

		//to check for complex fields like email (user can make it complex by enabling confirm email)
		$is_complex_field = false;
		$is_valid_input_field = false;

		foreach ( $div_classes_array as $div_class_value ) {
			if ( in_array( $div_class_value, $input_classes_types ) ) {
				$is_valid_input_field = true;
			}
			if ( strpos( $div_class_value, 'ginput_complex' ) !== false ) {
				$is_complex_field = true;
				
			}
		}
		// var_dump($field->type);
		// var_dump($is_valid_input_field);
		if ( $is_valid_input_field  && !$is_complex_field ) {
			//add class to input
			$inputs = $dom->getElementsByTagName( 'input' );
			foreach ( $inputs as $input ) {
				$id = $input->getAttribute( 'id' );

				$input_type = $input->getAttribute( 'type' );
				if ( preg_match( '/^input_/', $id ) ) {
					$icon_element = $dom->createElement( 'i' );
					$fontawesome_icon = str_replace( '_', ' ', $fontawesome_icon );
					$fontawesome_icon .= ' stla-fontawesome-icon';
					$icon_element->setAttribute( 'class', $fontawesome_icon );
					$div->setAttribute( 'style', 'position:relative' );
					$div->setAttribute( 'class', $div_classes . ' stla-fontawesome' );
					$div->insertBefore( $icon_element, $input );
					// $div->appendChild( $icon_element );
				}
			}
		}
		$content = utf8_decode($dom->saveHTML($dom->documentElement));;
	}
}
