import { __ } from '@wordpress/i18n';
import React from 'react';
import { FilterOperator } from '../FiltersControl';

export const availableOperators = {
	is: __( 'is', 'gp-entry-blocks' ),
	isnot: __( 'is not', 'gp-entry-blocks' ),
	'>': __( '>', 'gp-entry-blocks' ),
	'>=': __( '>=', 'gp-entry-blocks' ),
	'<': __( '<', 'gp-entry-blocks' ),
	'<=': __( '<=', 'gp-entry-blocks' ),
	contains: __( 'contains', 'gp-entry-blocks' ),
	does_not_contain: __( 'does not contain', 'gp-entry-blocks' ),
	starts_with: __( 'starts with', 'gp-entry-blocks' ),
	ends_with: __( 'ends with', 'gp-entry-blocks' ),
	like: __( 'is LIKE', 'gp-entry-blocks' ),
	is_in: __( 'is in', 'gp-entry-blocks' ),
	is_not_in: __( 'is not in', 'gp-entry-blocks' ),
};

export interface FilterOperatorControlProps {
	onChange: ( operator: string ) => void;
	value: FilterOperator;
	operators: FilterOperator[];
}

export const FilterOperatorControl = ( {
	onChange,
	value,
	operators,
}: FilterOperatorControlProps ) => {
	return (
		<select
			className="gpeb-filter-operator"
			onChange={ ( event ) =>
				onChange( event.target.value as FilterOperator )
			}
			onBlur={ ( event ) =>
				onChange( event.target.value as FilterOperator )
			}
			value={ value }
		>
			{ operators.map( ( availableOperator ) => (
				<option key={ availableOperator } value={ availableOperator }>
					{ availableOperators[ availableOperator ] }
				</option>
			) ) }
		</select>
	);
};
