<?php

/*
 * Plugin Name: Grid Layout Gravity Forms
 * Plugin URI: https://wpmonks.com/downloads/grid-layout
 * Description: Make Grid Layout of Gravity Form fields
 * Author: Sushil Kumar
 * Author URI: https://wpmonks.com
 * Version: 3.3.6
 * License: GPLv2
 */
// don't load directly
if ( ! defined( 'ABSPATH' ) ) die( '-1' );

//file to send automatic updates
include_once WP_PLUGIN_DIR . "/" . basename( dirname( __FILE__ ) ).'/update.php';

//set constants for plugin directory and plugin url
define( "STLA_GRID_LAYOUT_DIR", WP_PLUGIN_DIR . "/" . basename( dirname( __FILE__ ) ) );
define( "STLA_GRID_LAYOUT_URL", plugins_url() . "/" . basename( dirname( __FILE__ ) ) );
define( "STLA_GRID_LAYOUT_VERSION", '3.3.6' );

class Stla_Gravity_Grid_Layout {
	public $all_found_forms_ids = array();

	function __construct() {
		add_filter( 'gform_toolbar_menu', array( $this, 'gform_toolbar_menu' ), 10, 2 );
		add_action( 'admin_enqueue_scripts', array( $this, 'add_react_grid_scripts' ) );
		// add_action( 'admin_menu', array( $this, 'register_grid_menu') );
		//add_filter( 'gform_addon_navigation', array( $this, 'register_grid_menu' ) );
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'customize_controls_enqueue_scripts' ) );
		// save grid layout data
		add_action( 'wp_ajax_stla_grid_layout_save', array( $this, 'save_grid_layout' ) );

		// save enable disable
		add_action( 'wp_ajax_stla_grid_layout_enable_disable', array( $this, 'stla_grid_layout_enable_disable' ) );

		// Reset Grid
		add_action( 'wp_ajax_stla_grid_layout_reset', array( $this, 'stla_grid_layout_reset' ) );

		// Add container for fields
		add_filter( 'gform_field_container', array( $this, 'add_grid_container' ), 10, 6 );

		// Add pure grid scripts
		add_action( 'gform_enqueue_scripts', array( $this, 'gravity_form_scripts' ), 10, 2 );

		// Add Pre render
		//add_action( 'init', array( $this, 'init' ) );

		add_action( 'gform_editor_js', array( $this, 'editor_script' ) );

		//add_action( 'wp_enqueue_scripts', array( $this, 'frontend_styles' ) );
		// Add classes for radio and checkboxes
		add_filter( 'gform_field_css_class', array( $this, 'gform_field_css_class'), 10, 3 );

		// Customizer register action
		add_action('gf_stla_add_theme_section',array($this, 'grid_customizer_controls'), 13, 2);

		// old grid layout classes funciton
		add_filter( 'gform_field_css_class', array($this,'gf_stla_grid_layout_divide_colums'), 10, 3 );

		add_action( 'admin_notices', array( $this, 'check_plugin_dependencies' ) );

		// Register script with Gravity Forms no-conflict mode
		add_filter( 'gform_noconflict_scripts', array( $this, 'register_script' ) );

		// Register style with Gravity Forms no-conflict mode
		add_filter( 'gform_noconflict_styles', array( $this, 'register_style' ) );

		// Add class to form 
		add_filter( 'gform_pre_render', array( $this, 'gform_pre_render' ), 10, 3 );

		// update grid after field has added
		add_action( 'gform_after_save_form',array( $this, 'update_grid_after_update') , 10, 2 );

		// duplicate grid on duplicating form
		add_action( 'gform_after_duplicate_form', array( $this, 'duplicate_grid' ), 10, 2 );

	} //constructor ends here

	function duplicate_grid( $old_form_id, $new_form_id ) {
		$old_grid = get_option( 'gf_stla_grid_layout_'.$old_form_id ) ;

		update_option( 'gf_stla_grid_layout_'.$new_form_id, $old_grid );
	}

	function update_grid_after_update( $form, $is_new  ){
		
		$form_id = $form['id'];
		$grid = get_option( 'gf_stla_grid_layout_'.$form_id ) ;
		$status = isset($grid['enabled']) ? $grid['enabled'] : false;

		if($is_new || !$status ){
			return;
		}
		echo '<script>
		// opening the grid after update form
		var url = document.location.href;
		if(url.search("&stla_grid=true") < 0 && url.search("page=gf_edit_forms") > -1){
			url += "&stla_grid=return_editor";
			window.open(url, "_top"); 
		}
		</script>' ;
	}
		
	function gform_pre_render( $form, $ajax, $field_values ) {
		$form_id = $form['id'];
		$grid = get_option( 'gf_stla_grid_layout_'.$form_id ) ;
		$enabled = isset( $grid['enabled'] ) ? $grid['enabled'] : false;

		if( $enabled ) {
			$form['cssClass'] = !empty( $form['cssClass'] ) ? $form['cssClass'].' stla_grid_root' : 'stla_grid_root';
		}

		return $form;
	}

	// customizer control
	function grid_customizer_controls( $wp_customize, $current_form_id) {
		$wp_customize->add_section( 'gf_stla_form_id_grid_layout' , array(
			'title' => 'Grid Layout',
			'panel' => 'gf_stla_panel',
		) );
	
		$wp_customize->add_control('gf_stla_gird_form_id_'.$current_form_id.'[redirect-text]',array(
			'type'        => 'hidden',
			'priority'    => 10, // Within the section.
			'section'     => 'gf_stla_form_id_grid_layout', // Required, core or custom.
			'label'       => __( 'Check our new Grid Editor' ),
			'description' => 'We have created a new and easy to use drag and drop grid builder. <a href="'.get_admin_url().'admin.php?page=gf_edit_forms&id='.$current_form_id.'&stla_grid=true">Click here</a> to open it. You can also <a href="https://www.youtube.com/watch?v=XdMIEU3XtSk" target="_blank">check our video</a> for new Grid editor.',
			'settings' => array(),
		));
	}

	// Reset Grid
	function stla_grid_layout_reset() {
		$form_id =  $_POST['id'];
		
		delete_option('gf_stla_grid_layout_'.$form_id );

		echo $form_id ;
		die();
	}

	// Enable/Disable Form
	function stla_grid_layout_enable_disable() {
		$form_id =  $_POST['id'];
		$status = $_POST['status'];

		$grid = get_option( 'gf_stla_grid_layout_'.$form_id ) ;
		$status = $status === 'false'? false: true;
		$grid['enabled'] = $status;

		// Old settings
		$old_settings = get_option( 'gf_stla_form_id_grid_layout_'.$form_id );

		if( $old_settings ) {
			// Keep old layout safe just in case we need it
			update_option( 'gf_stla_form_id_grid_layout_old'.$form_id, $old_settings );

			// Delete the old layout and use the new editor	
			delete_option( 'gf_stla_form_id_grid_layout_'.$form_id );
		}
		

		update_option('gf_stla_grid_layout_'.$form_id, $grid );

		echo $form_id ;
		die();
	}

	// old grid layout classes
	function gf_stla_grid_layout_divide_colums( $classes, $field, $form ) {
		$column_layout_data = get_option( 'gf_stla_form_id_grid_layout_'.$form['id'] );
		
		if ( !empty( $column_layout_data ) ) {
			if ( array_key_exists( $field->type, $column_layout_data ) ) {
					$column_layout_data_fields = $column_layout_data[ $field->type ];
					if ( array_key_exists( $field->id, $column_layout_data_fields ) ) {
							$classes .= ' '.$column_layout_data_fields[ $field->id ];
					}
			}
		}
		return $classes;	
	}

	//check if styles and layouts is present
	function check_plugin_dependencies() {
		if ( ! class_exists( 'Gravity_customizer_admin' ) ) {
			$class = 'notice notice-error';
			$styles_layouts_url = admin_url( 'plugin-install.php?s=styles+and+layouts+for+gravity+forms&tab=search&type=term');
			$message = '<a href="'.$styles_layouts_url.'">Styles & Layouts for Gravity Forms </a>is not installed. <strong>Gravity Forms Grid Layout</strong> requires it to deliver future updates.';

			printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ),  $message  );
		}
	}

	function editor_script( ) {

		// $form = GFAPI::get_form( 30 );
		// echo '<pre>';
		
		// print_r( $form );
		// die();

		$form_id = $_GET[ 'id'];

			// delete_option('gf_stla_grid_layout_'.$form_id );
			$form = GFAPI::get_form( (int) $form_id );
			$grid = get_option( 'gf_stla_grid_layout_'.$form_id ) ;
			$layout = isset($grid['layout']) ? $grid['layout'] : 'false';
			if( ! is_string( $layout ) ) { // is not already json encoded.. added in 3.3.3
				$layout = json_encode( $layout );
			}
			$form_data = array();
            foreach ( $form['fields'] as $field ) {
				$input_type = empty( $field['inputType'] ) ? '' : $field['inputType'];
                $form_data[] = array(
                    'id' => ( string ) $field['id'], // sending as string because it is used as key in order.fields
                    'label' => $field['label'],
                    'type' => $field['type'],
					'page' => $field['pageNumber'],
					'inputType' => $input_type
                );
			}
		$form_fields = json_encode( $form_data );
	
		
		// Old settings
		$old_settings = get_option( 'gf_stla_form_id_grid_layout_'.$form_id );
		$old_layout = 'false';
		if( $old_settings ) {
			$old_layout = array();
			foreach( $old_settings as $old_setting_type => $old_setting_value ) {
				foreach( $old_setting_value as $field_id => $class ){
					$old_layout[$field_id]  = $class;
				}
			}

			$old_layout = json_encode( $old_layout );

			

			// // Old settings exists then enable new grid by default
			// $grid['enabled'] = true;

			// // Save enabled in database as well.
			// update_option( 'gf_stla_grid_layout_'.$form_id, $grid ) ;
		}

		$enabled  = isset( $grid['enabled'] )? $grid['enabled']: false;
	

		echo '<script> 
				var stlaGf = { grid: { 
								formFields:'.$form_fields.', 
								formId:'.$form_id.', 
								layout:'. $layout .',
								oldLayout:'.$old_layout.',
								}
							};
			</script>'; 

		echo '<script>
		var gridRootContainer = document.createElement("div");
		var gridDisableContainer = document.createElement("div");
		var gridDisableCheckbox = document.createElement("input");
		var gridDisableLabel = document.createElement("label");
		var gridRoot = document.createElement("div");
		var wpcontentElem = document.getElementById("wpbody-content");
		var resetButtonContainer = document.createElement("div");
		var resetButton = document.createElement("button");
		var gridSettingHeader = document.createElement("div");
		gridRootContainer.id = "stla-grid-container";
		gridRootContainer.style.display = "none";

		gridDisableContainer.id = "stla-grid-disable";
		gridRoot.id = "stla-grid-root";
		gridRoot.classList.add("stla_grid_root_wrapper");

		jQuery(gridDisableLabel).text( "Enable Grid Layout" ) ;
		jQuery(resetButton).text("Reset Layout");
		gridDisableLabel.setAttribute("for", "stla-disable-grid");

		gridDisableCheckbox.setAttribute("type", "checkbox");
		gridDisableCheckbox.setAttribute("class", "stla-disable-grid");
		gridSettingHeader.setAttribute("id", "stla-grid-head-setting-container");
		gridDisableCheckbox.setAttribute("id", "stla-disable-grid");
		resetButtonContainer.setAttribute("id", "stla-layout-reset");';

		if( $enabled ) {
			echo 'gridDisableCheckbox.setAttribute( "checked", "checked");';
		}

		echo 'wpcontentElem.appendChild(gridRootContainer);
		gridDisableContainer.appendChild(gridDisableCheckbox);
		gridDisableContainer.appendChild(gridDisableLabel);
		resetButtonContainer.appendChild(resetButton);

		gridRootContainer.appendChild(gridSettingHeader);
		gridSettingHeader.appendChild(gridDisableContainer);
		gridSettingHeader.appendChild(resetButtonContainer);
		gridRootContainer.appendChild(gridRoot);

		// Enable disable blur of grid layout
		function enableDisable(){
			var checkEnable = jQuery(".stla-disable-grid").prop( "checked" );
			if(checkEnable){
				jQuery("#stla-grid-root").addClass("grid-enabled");
				jQuery("#stla-grid-root").removeClass("grid-disabled");
			} else{
				jQuery("#stla-grid-root").addClass("grid-disabled");
				jQuery("#stla-grid-root").removeClass("grid-enabled");

			}
		}

		// Switching between editor and grid layout
		var gravityEditContainer = document.querySelector(".gforms_edit_form table");
		var stlaFormEditorBtn = document.querySelector(".gf_form_toolbar_editor a");
		var stlaGridBtn = document.querySelector(".stla-grid-togl-btn a");
		var url = document.location.search;

		// when grid option is clicked from toolbar.
		stlaGridBtn.onclick = function(e) {
			e.preventDefault();
			if( url.search("&stla_grid=true") === -1 ){
				url = e.target.href;
				window.history.pushState("stlaLayoutEditor","",url)
				document.querySelector(".update-form").click();
				
			}
		}
		
		// inside grid editor page.
		if( url.search("&stla_grid") > 1 ){		
			gridRootContainer.style.display = "block";
			gravityEditContainer.style.display = "none";
			stlaFormEditorBtn.classList.remove("gf_toolbar_active");
			stlaGridBtn.classList.add("gf_toolbar_active");
		}

		// Enable Disable button	
		jQuery( document ).ready(function( $ ) {			
			enableDisable();
			if( $(".grid-save-btn").length ) {
				document.querySelector(".grid-save-btn").click();
			}

			jQuery( "#stla-disable-grid" ).on( "click", function( e ) {
				var isEnabled = jQuery("#stla-grid-disable input").is(":checked");

				const postData = { 
					action:  "stla_grid_layout_enable_disable", 
					status: isEnabled,
					id: '. $form_id .'
				} ;
		
				// AJAX request to get 
				jQuery.post(  ajaxurl, postData, function( response ) {
					enableDisable();

				} );
			});

			// back to form editor after update form
			if( url.search("&stla_grid=return_editor") > 1 ){		
				var href= document.location.href;
				var editorUrl = href.replace("&stla_grid=return_editor", " ");
				window.open(editorUrl, "_top");
			}
		});
			
		// Reset Styles
		jQuery( document ).ready(function( $ ) {
			jQuery( "#stla-layout-reset" ).on( "click", function( e ) {
				var deleteLayout = confirm( "This will remove your saved grid layout from the form and reset it to default onc column layout.");

				if( deleteLayout === false ) {
					return;
				}
					
				const postData = { 
					action:  "stla_grid_layout_reset", 
					id: '. $form_id .'
				} ;
			
				// AJAX request to reset layout
				jQuery.post(  ajaxurl, postData, function( response ) {
					location.reload();
	
				});
			});
		});
			
		</script>';
	} 

	function gform_field_css_class( $classes, $field, $form ) {

		$grid = get_option( 'gf_stla_grid_layout_'.$form['id'] ) ;
		
		
		// Return if grid not set or grid is not enabled
        if (! $grid || is_admin() || ! isset( $grid['enabled'] ) || ! $grid['enabled'] || ! isset( $grid['layout'] ) ) {
            return $classes;
		}
		$layout = $grid['layout'];
		if( is_string( $layout ) ) { // is saved as json encoded value.. added in 3.3.3
			$layout = json_decode( $layout, true );
		}

		$fields = $layout['fields'];

		// Only add classes for checkbox or radio and where field size is not default
		if ( ( $field->type == 'radio' || $field->type == 'checkbox' || $field->inputType == 'radio' || $field->inputType == 'checkbox' ) && $layout['fields'][$field->id]['size'] !== 'default' ) {
			$classes .= ' '.$layout['fields'][$field->id]['size'];
		}
		return $classes;
	}



	function gravity_form_scripts( $form, $is_ajax ) {
		wp_enqueue_style( 'stla_grid_frontend_bootstrap', STLA_GRID_LAYOUT_URL .'/css/bootstrap-grid.css', array(), STLA_GRID_LAYOUT_VERSION );
		wp_enqueue_style( 'stla_grid_frontend_custom', STLA_GRID_LAYOUT_URL .'/css/style.css', array(), STLA_GRID_LAYOUT_VERSION );

	}
	

	/**
	 * Adds grid layout classes and structure to form fields
	 *
	 * @param [type] $field_container
	 * @param [type] $field
	 * @param [type] $form
	 * @param [type] $css_class
	 * @param [type] $style
	 * @param [type] $field_content
	 * 
	 * @since 1.0
	 * 
	 * @return void
	 */
	function add_grid_container( $field_container, $field, $form, $css_class, $style, $field_content ) {
		$grid = get_option( 'gf_stla_grid_layout_'.$form['id'] ) ;

       // Return if grid not set or grid is not enabled
	   if (! $grid || is_admin() || ! isset( $grid['enabled'] ) || ! $grid['enabled'] || ! isset( $grid['layout'] ) || $field->type === 'honeypot') {
			return $field_container;
		}
		$layout = $grid['layout'];
		
		if( is_string( $layout ) ) { // is saved as json encoded value.. added in 3.3.3
			$layout = json_decode( $layout, true );
		}

		$columns = $layout['columns'];
		$rows = $layout['rows'];
		$fields = $layout['fields'];


		$parent_column = $fields[$field->id]['parentCol'];
		$column_fields_count = count( $layout['columns'][$parent_column]['fields'] );
		$parent_column_first_field = $layout['columns'][$parent_column]['fields'][0];
		$parent_column_last_field = $layout['columns'][$parent_column]['fields'][$column_fields_count - 1];
		$parent_row = $layout['columns'][$parent_column]['parentRow'];
		$parent_column_size = $layout['columns'][$parent_column]['size'];
		$prev_empty_columns = (int) $columns[$parent_column]['prevEmptyCols'];
		$next_empty_columns = (int) $columns[$parent_column]['nextEmptyCols'];
		$is_first_field = $columns[$parent_column]['hasFirstField'];
		$is_last_field = $columns[$parent_column]['hasLastField'];
		$parent_column_class = 'col-md-'.$parent_column_size.' ';
		if( $parent_column_size === 'auto' ) {
			$parent_column_class = 'col-md ';
		}
		
		//	$field_container = str_replace("class='", "class='".$parent_column_class, $field_container );
		$html = '';
		$parent_column_index = array_search( $parent_column, $rows[$parent_row]['columns'] );
		
		// If its the first field of row + column with no previous empty coloums then start a row
		// Earlier the data was saved as object.. in that case boolean was convered into string.. so 'true'
		// Now we send it as json encoded string.. which preserves boolean.. so true
		if( ( $is_first_field === 'true' || $is_first_field === true) && $parent_column_first_field == $field->id && $prev_empty_columns === 0 ) { 
			$html .= '<li id="'.$parent_row.'" class="row">';
		}
		
		// Has empty columns before this field + this is the first field of its column
		if(  $prev_empty_columns > 0 && $parent_column_first_field == $field->id) { 
			$first_empty_column = $parent_column_index - $prev_empty_columns;
			for( $i = $first_empty_column; $i < $parent_column_index; $i++ ) {
				$column_id = $rows[$parent_row]['columns'][$i];
				$column_size = $columns[$column_id]['size'];
				$column_class = $column_size === 'auto'? 'col-md': 'col-md-'.$column_size;
				
				// If its the first field of row, first field of column and first empty column then start a row
				// Earlier the data was saved as object.. in that case boolean was convered into string.. so 'true'
				// Now we send it as json encoded string.. which preserves boolean.. so true
			if ( ( $is_first_field === 'true' || $is_first_field === true) && $i === $first_empty_column) {
                    $html .= '<li id="'.$parent_row.'" class="row"><ul id="'.$column_id.'" class="'.$column_class.'"><li class="stla-grid-empty-col" ></li></ul>';
				}
				else {
					$html .= '<ul id="'.$column_id.'" class="'.$column_class.'"><li class="stla-grid-empty-col" ></li></ul>';
				}
			}
		}

		if( $parent_column_first_field == $field->id ) { //  first field of its column then start column
			$html .= '<ul id="'.$parent_column.'" class="'.$parent_column_class.'" >';
		}

		$html .= $field_container;

		if( $parent_column_last_field == $field->id ) { // last field of the column
			$html .= '</ul>';
		}

		// Earlier the data was saved as object.. in that case boolean was convered into string.. so 'true'
		// Now we send it as json encoded string.. which preserves boolean.. so true
		if( ( $is_last_field === 'true' || $is_last_field === true) && $parent_column_last_field == $field->id ) { // last field of column then check next columns if it is last field
	
			if( $next_empty_columns > 0 ) { // has empty columns after last field
				$last_empty_column = $parent_column_index + $next_empty_columns;
				for( $i = $parent_column_index+1; $i <= $last_empty_column;  $i++ ) {
					$column_id = $rows[$parent_row]['columns'][$i];
					$column_size = $columns[$column_id]['size'];
					$column_class = $column_size === 'auto'? 'col-md': 'col-md-'.$column_size;
				
					$html .= '<ul id="'.$column_id.'" class="'.$column_class.'"><li class="stla-grid-empty-col" ></li></ul>';
				}
			}
			$html .= '</li>'; // end row
		}

		return $html;
	}

	/* Ajax Call  to save form*/
	function save_grid_layout() {
		$layout = $_POST['layout'];
		$layout = wp_unslash( $layout );
		$layout = json_decode( $layout, true );

		// Form id or $fields_order is not set then probably all json data is not recieved.
		// In this case show error
		if( ! isset( $_POST['formId'] ) || ! isset( $layout['order']['fields'] ) ) {
			echo 'Error: Please ask hosting provider to increase \'max_input_vars\' to 5000.';

			die();
		}

		

		$form_id = $_POST['formId'];
		
		$form = GFAPI::get_form( $form_id );
		$fields_order = $layout['order']['fields'];
		$layout_rows = $layout['rows'];
		$layout_columns = $layout['columns'];
		$layout_fields = $layout['fields'];
		$form_fields = $form['fields'];
		$current_page = false;

		$grid = get_option('gf_stla_grid_layout_'.$form_id );
	
		// empty form fields
		$form['fields'] = array();

		foreach( $fields_order as $field_id ) {
			$field_column_id = $layout_fields[$field_id]['parentCol'];
			$field_row_id = $layout_columns[$field_column_id]['parentRow'];
			$field_page_id = (int) str_replace( 'page', '', $layout_rows[$field_row_id]['parentPage']);


			// current page is set and it is not equal to previous current page
			// add the page field
			if( $current_page && $current_page != $field_page_id ) {
				foreach( $form_fields as $form_field ) { 
					if( $form_field->type === 'page' && $form_field->pageNumber === $field_page_id ) {
						array_push( $form['fields'], $form_field );
					}
				}
			}

			foreach( $form_fields as $form_field ) {
				if( (int) $form_field->id == $field_id ) {
					array_push( $form['fields'], $form_field );
				}
			}
			$current_page = $field_page_id;
		}

		// Update the form 
		$result = GFAPI::update_form( $form );
		$layout= json_encode($layout );
		if ( isset( $layout ) ) {
			$grid['layout'] = $layout;

			update_option('gf_stla_grid_layout_'.$form_id, $grid );
			echo 'true';
		}
		else {
			echo 'Grid or Formdata wasn\'t set';
		}
		die();
	}

	/**
	 * Registers 'Grid Layout' submenu under forms
	 *
	 * @param [array] $menus
	 * @return $menu updated menu
	 * @since 1.0
	 */
	function register_grid_menu( $menus ){
		$menus[] = array( 'name' => 'stla_grid_layout', 'label' => __( 'Grid Layout' ), 'callback' =>  array( $this, 'grid_layout_menu_callback' ) );
 		 return $menus;
	}


	/**
	 * Adds Styles & Layouts to Toolbar in  Gravity form edit screen
	 */

	public function gform_toolbar_menu( $menu_items, $form_id ) {
		$menu_items['styles-layouts-gf-grid'] = array(
			'icon'         => '<i class="fa fa-columns fa-lg"></i>',
			'label'        => 'Grid Layout', // the text to display on the menu for this link
			'title'        => 'Grid Layout', // the text to be displayed in the title attribute for this link
			'url'          => get_admin_url().'admin.php?page=gf_edit_forms&id='.$form_id.'&stla_grid=true', // the URL this link should point to
			'menu_class'   => 'stla-grid-togl-btn', // optional, class to apply to menu list item (useful for providing a custom icon)
			'link_class'   => rgget( 'page' ) == 'my_custom_page' ? 'gf_toolbar_active' : '*', // class to apply to link (useful for specifying an active style when this link is the current page)
			'capabilities' => array( 'gravityforms_edit_forms' ), // the capabilities the user should possess in order to access this page
			'priority'     => 500, // optional, use this to specify the order in which this menu item should appear; if no priority is provided, the menu item will be append to end
		);
		return $menu_items;
	}

	function add_react_grid_scripts() {

		// Not on form editor page then don't load scripts
		if( ! isset( $_GET['page'] ) || $_GET['page'] !== 'gf_edit_forms' || ! isset( $_GET['stla_grid'] )  ) {
			return;
		}

		$js_dir    = plugin_dir_path( __FILE__ ) . '/build/static/js';
		$js_files = array_diff( scandir( $js_dir ), array( '..', '.' ) );
		$count = 0;
		foreach ( $js_files as $js_file ) {
			if ( strpos( $js_file , '.js.map'  )  === false  ) {
				$js_file_name = $js_file;
				wp_enqueue_script( 'stla_grid_dnd_'.$count, plugin_dir_url( __FILE__ ).'/build/static/js/' .$js_file_name, array( 'jquery' ), STLA_GRID_LAYOUT_VERSION, true );
				$count++;
			}
		}

		$css_dir    = plugin_dir_path( __FILE__ ) . '/build/static/css';
		$css_files = array_diff( scandir( $css_dir ), array( '..', '.' ) );

		foreach ( $css_files as $css_file ) {
			if ( strpos( $css_file , '.css.map'  ) === false ) {
				$css_file_name = $css_file;
			}
		}
		
		wp_enqueue_style( 'react_grid_style', plugin_dir_url( __FILE__ ) . 'build/static/css/' . $css_file_name, array(), STLA_GRID_LAYOUT_VERSION );

		wp_enqueue_style( 'stla_grid_backend_bootstrap', STLA_GRID_LAYOUT_URL .'/css/bootstrap-grid.css', array(), STLA_GRID_LAYOUT_VERSION );

		wp_enqueue_script( 'stla_grid_admin', STLA_GRID_LAYOUT_URL . '/js/admin.js', array( 'jquery' ), STLA_GRID_LAYOUT_VERSION );
		wp_enqueue_style( 'stla_grid_admin', STLA_GRID_LAYOUT_URL . '/css/admin.css', array(), STLA_GRID_LAYOUT_VERSION );
	}

	/**
	 * Register scripts for no-conflict mode in gravity forms
	 *
	 * @param [array] $scripts
	 * @return $scripts
	 */
	function register_script( $scripts ) {
		//registering my script with Gravity Forms so that it gets enqueued when running on no-conflict mode
		
		// scripts
		$scripts[] = 'stla_grid_admin';
		$scripts[] = 'stla_grid_dnd_0';
		$scripts[] = 'stla_grid_dnd_1';
		$scripts[] = 'stla_grid_dnd_2';
		$scripts[] = 'stla_grid_dnd_3';

		return $scripts;
	}

	/**
	 * Register styles for no-conflict mode in gravity forms
	 *
	 * @param [array] $styles
	 * @return $styles
	 */
	function register_style( $styles ) {
		//registering my style with Gravity Forms so that it gets enqueued when running on no-conflict mode
		// Styles
		$styles[] = 'react_grid_style';
		$styles[] = 'stla_grid_backend_bootstrap';
		$styles[] = 'stla_grid_admin';

		return $styles;
	}

	function customize_controls_enqueue_scripts() {
		wp_enqueue_script('customizer_controls', STLA_GRID_LAYOUT_URL.'/js/customizer-controls.js', array( 'jquery' ), STLA_GRID_LAYOUT_VERSION, true );
	}

} //class ends here

add_action( 'plugins_loaded', 'stla_gravity_grid_layout' );

function stla_gravity_grid_layout() {
	new Stla_Gravity_Grid_Layout();
}
