import { __ } from '@wordpress/i18n';

export const variations = [
	{
		name: 'entries-table',
		title: __( 'Entries Table', 'gp-entry-blocks' ),
		description: __( 'Repeating table rows for each entry.', 'gp-entry-blocks' ),
		icon: 'editor-table',
		innerBlocks: [
			[
				'gp-entry-blocks/entries-table',
				{
					formFields: [
						{ type: 'id' },
						{ type: 'edit-link' },
						{ type: 'view-link' },
					],
				},
			],
			[ 'gp-entry-blocks/pagination' ],
			[
				'gp-entry-blocks/edit-entry',
				{},
				[
					[ 'gp-entry-blocks/edit-form' ],
					[ 'core/paragraph', { content: '{go_back_link}' } ],
				],
			],
			[
				'gp-entry-blocks/view-entry',
				{},
				[
					[ 'core/paragraph', { content: '{all_fields}' } ],
					[ 'core/paragraph', { content: '{go_back_link}' } ],
				],
			],
		],
		scope: [ 'block' ],
	},
	{
		name: 'entries-loop',
		title: __( 'Entries Loop', 'gp-entry-blocks' ),
		description: __( 'Repeating blocks for each entry.', 'gp-entry-blocks' ),
		icon: 'controls-repeat',
		innerBlocks: [
			[
				'gp-entry-blocks/entries-loop',
				{},
				[
					[ 'core/paragraph', { content: '{all_fields}' } ],
					[ 'core/paragraph', { content: '{view_link}' } ],
					[ 'core/paragraph', { content: '{edit_link}' } ],
				],
			],
			[ 'gp-entry-blocks/pagination' ],
			[
				'gp-entry-blocks/edit-entry',
				{},
				[
					[ 'gp-entry-blocks/edit-form' ],
					[ 'core/paragraph', { content: '{go_back_link}' } ],
				],
			],
			[
				'gp-entry-blocks/view-entry',
				{},
				[
					[ 'core/paragraph', { content: '{all_fields}' } ],
					[ 'core/paragraph', { content: '{go_back_link}' } ],
				],
			],
		],
		scope: [ 'block' ],
	},
	{
		name: 'edit-entry',
		title: __( 'Edit Single Entry', 'gp-entry-blocks' ),
		description: __( 'Edit form for a single pre-determined entry.', 'gp-entry-blocks' ),
		icon: 'welcome-write-blog',
		attributes: {
			mode: 'edit-single',
		},
		innerBlocks: [
			[
				'gp-entry-blocks/edit-entry',
				{},
				[ [ 'gp-entry-blocks/edit-form' ] ],
			],
		],
		scope: [ 'block' ],
	},
	{
		name: 'view-entry',
		title: __( 'Single Entry', 'gp-entry-blocks' ),
		description: __( 'Show the contents of a single entry.', 'gp-entry-blocks' ),
		icon: 'media-default',
		attributes: {
			mode: 'view-single',
		},
		innerBlocks: [
			[
				'gp-entry-blocks/view-entry',
				{},
				[ [ 'core/paragraph', { content: '{all_fields}' } ] ],
			],
		],
		scope: [ 'block' ],
	},
];
