<?php

/***************************************** for textarea **************************************************************/

if ( $field->type === 'textarea' || $field->type === 'post_content' || $field->type === 'post_excerpt' ) {
	

	$divs = $dom->getElementsByTagName( 'div' );
	//var_dump( $divs );
	$contains_error = false;
	$contains_character_count = false;
	foreach ( $divs as $div ) {
		$current_div_classes = $div->getAttribute( 'class' );
		if ( strpos( $current_div_classes, 'validation_message' ) !== false ) {
			$contains_error = true;
			$div->setAttribute( 'class', $div->getAttribute( 'class' ) . ' mdc-text-field-helper-text mdc-text-field-helper-text--persistent mdc-text-field-helper-text--validation-msg' );
		}

		if ( strpos( $current_div_classes, 'ginput_container' ) !== false ) {
			$contains_character_count = true;
		}
	}

	foreach( $divs as $div ) {
		$contains_placeholder = false;
		$add_label_classes = '';
		$div_classes = $div->getAttribute( 'class' );
		$textareas = $div->getElementsByTagName( 'textarea' );
		$is_tinymce = true;

		foreach ( $textareas as $textarea ) {
			$textarea_classes = $textarea->getAttribute( 'class' );
			$textarea_classes_array = explode( ' ', $textarea_classes );
			
			//if this is not a tinymce editor only then apply material design
			if ( !in_array('wp-editor-area', $textarea_classes_array ) ) {
				$is_tinymce = false;
			}
		}	

		if ( ( strpos( $div_classes, 'ginput_container_textarea' ) !== false || strpos( $div_classes, 'ginput_container_post_excerpt' ) !== false) && ! $is_tinymce ) {
			if ( $contains_error ) {
				$div_classes .= ' mdc-text-field--invalid';
			}

			// custom class for character count
			$div_classes .= ! empty( $field->maxLength ) ? ' stla-charleft': '';

			$div->setAttribute( 'class', $div_classes . ' mdc-text-field mdc-text-field--textarea' );
			$div->setAttribute( 'data-mdc-auto-init', 'MDCTextField' );
			foreach ( $textareas as $textarea ) {
				if ( $textarea->getAttribute( 'placeholder' ) !== '' && $type !== 'outlined') {
					$add_label_classes .= ' mdc-floating-label--float-above';
				}
				if( $contains_character_count ){
					$textarea->setAttribute( 'class',
					$textarea->getAttribute( 'class' ) . ' stla_material_char_counter' );
				}
				$textarea->setAttribute( 'class',
					$textarea->getAttribute( 'class' ) . ' mdc-text-field__input' );
			}
			$labels = $dom->getElementsByTagName( 'label' );
			
			foreach ( $labels as $label ) {
				$add_label_classes .= ' mdc-floating-label';

				$notched_outline = $dom->createElement('div');
				$notched_outline->setAttribute( 'class', 'mdc-notched-outline' );

				$notched_outline_leading = $dom->createElement( 'div' );
				$notched_outline_leading->setAttribute( 'class', 'mdc-notched-outline__leading' );
				
				$notched_outline_notch = $dom->createElement( 'div' );
				$notched_outline_notch->setAttribute( 'class', 'mdc-notched-outline__notch' );

				$notched_outline_trailing = $dom->createElement( 'div' );
				$notched_outline_trailing->setAttribute( 'class', 'mdc-notched-outline__trailing' );
				
				if ( $contains_placeholder ) {
					$notched_outline->setAttribute( 'class', 'mdc-notched-outline mdc-notched-outline--notched' );
				}
				$div->appendChild( $notched_outline );

				$notched_outline->appendChild( $notched_outline_leading );
				$notched_outline->appendChild( $notched_outline_notch );
				$notched_outline->appendChild( $notched_outline_trailing );

				$label->setAttribute('class', $label->getAttribute( 'class' ) . $add_label_classes );
				$notched_outline_notch->appendChild( $label );
				
				// $label->setAttribute( 'class', $label->getAttribute( 'class' ) . $add_label_classes );
				// $div->appendChild( $label );
			}
		}
		
		// // for character count
		// if( ( strpos( $div_classes, 'charleft' ) !== false ) ) {
		// 	var_dump( 'here' );
		// 	$div->setAttribute( 'class', $div_classes . ' mdc-text-field-character-counter' );
		// }
	}

	$content = utf8_decode( $dom->saveHTML( $dom->documentElement ) );
}
