
jQuery(document).ready(function($) {

	// Get all loca
	function getGlobalProperties(prefix) {
		var keyValues = [], global = window; // window for browser environments
		for (var prop in global) {
		  if (prop.indexOf(prefix) == 0) // check the prefix
			keyValues.push(prop );
		}
		return keyValues; // 
	  }

	  // All localized variables in array
	  var stla_tooltips = getGlobalProperties('stla_tooltips_localize_');

	
	  function applyTooltips(){
		stla_tooltips.forEach( function( stla_tooltip ){

			var tooltipSettings =  window[stla_tooltip].settings;
			// tooltips are enabled
			if( tooltipSettings.enabled ) {
				var tooltipEls = document.querySelectorAll('#gform_wrapper_'+tooltipSettings.formId + ' [data-tippy-content]');
				tippy(tooltipEls, {
					interactive: true,
					theme: tooltipSettings.theme,
					animation: tooltipSettings.animation,
					placement: tooltipSettings.position,
					maxWidth: tooltipSettings.maxWidth,
					arrow: true,
					arrowType: 'round'
				});
			}
		  });
	  }
	  
	// for non ajax forms
	applyTooltips();

	// for ajax multipage
	jQuery(document).on('gform_page_loaded', function(){
		applyTooltips();
	});
});


