/**
 * Removes query params such as duplicate_entry, delete_entry, and _wpnonce from the URL to prevent
 * re-duplication from happening if a page is refreshed.
 *
 * We chose this route over a wp_redirect() to improve page speed. POST is still on the table as it might work better
 * with aggressive caching, but comes with the trade-off of still getting a browser confirmation dialog on refresh.
 */
const removeActionQueryParams = () => {
	const { pathname, search } = window.location;
	const params = new URLSearchParams( search );
	const existingParams = params.toString();

	params.delete( '_wpnonce' );
	params.delete( 'delete_entry' );
	params.delete( 'duplicate_entry' );

	// Only push state if we actually removed a param.
	if ( existingParams === params.toString() ) {
		return;
	}

	let url = pathname;

	if ( params.toString() ) {
		url += `?${ params.toString() }`;
	}

	history.pushState( null, '', url );
};

removeActionQueryParams();
