/**
 * WordPress provides React during the page load. This is for TypeScript type checking only.
 *
 * Importing React from @wordpress/element causes "Cannot read property 'createElement' of undefined"
 */
import React from 'react';

import { InspectorControls } from '@wordpress/block-editor';
import { PanelBody, TextControl, ToggleControl } from '@wordpress/components';
import { __ } from '@wordpress/i18n';
import { PaginationAttributes } from './index';

export default function PaginationInspectorControls(
	props: BlockProps< PaginationAttributes >
) {
	return (
		<InspectorControls>
			<PanelBody
				className="gpeb_panel_pagination_settings"
				title={ __( 'Settings', 'gp-entry-blocks' ) }
			>
				<ToggleControl
					checked={ props.attributes?.showNextPrevious }
					onChange={ ( showNextPrevious ) =>
						props.setAttributes( { showNextPrevious } )
					}
					label={ __( 'Show Next/Previous Links', 'gp-entry-blocks' ) }
				/>
				<ToggleControl
					checked={ props.attributes?.showNumbers }
					onChange={ ( showNumbers ) =>
						props.setAttributes( { showNumbers } )
					}
					label={ __( 'Show Page Number Links', 'gp-entry-blocks' ) }
				/>
			</PanelBody>
			<PanelBody
				className="gpeb_panel_pagination_labels"
				title={ __( 'Labels', 'gp-entry-blocks' ) }
			>
				<TextControl
					value={ props.attributes?.previousLabel }
					onChange={ ( previousLabel ) =>
						props.setAttributes( { previousLabel } )
					}
					label={ __( 'Previous', 'gp-entry-blocks' ) }
				/>
				<TextControl
					value={ props.attributes?.nextLabel }
					onChange={ ( nextLabel ) =>
						props.setAttributes( { nextLabel } )
					}
					label={ __( 'Next', 'gp-entry-blocks' ) }
				/>
			</PanelBody>
		</InspectorControls>
	);
}
