/**
 * WordPress provides React during the page load. This is for TypeScript type checking only.
 *
 * Importing React from @wordpress/element causes "Cannot read property 'createElement' of undefined"
 */
import React from 'react';
import { useBlockProps, InnerBlocks } from '@wordpress/block-editor';
import { __ } from '@wordpress/i18n';

const Edit = ( args: BlockProps< any > ) => {
	const blockProps = useBlockProps();

	return (
		<div { ...blockProps }>
			<InnerBlocks
				template={ [
					[ 'core/heading', { content: __( 'Edit Entry', 'gp-entry-blocks' ), level: 3 } ],
					[ 'gp-entry-blocks/edit-form' ],
				] }
			/>
		</div>
	);
};

const Save = () => {
	const blockProps = useBlockProps.save();

	return (
		<div { ...blockProps }>
			<InnerBlocks.Content />
		</div>
	);
};

export const settings = {
	edit: Edit,
	save: Save,
};
