<?php

namespace GP_Entry_Blocks\Blocks\Entries_Table;

use GFAPI;

/**
 * Class that defines the interface of columns in GP_Entry_Blocks\Blocks\Entries_Table\Table
 */
class Column {

	/**
	 * The type of column.
	 *
	 * @var string
	 */
	public $type;

	/**
	 * Associated metadata with the column. Can contain keys such as field, label, etc.
	 *
	 * @var array
	 */
	public $meta;

	/**
	 * Sorting identifier to use when passing to \GF_Query.
	 *
	 * @var string|number|null
	 */
	public $sorting_id;

	/**
	 * @param string        $type       The type of column. Example: `id`, `custom`, `edit-link`
	 * @param mixed         $meta       Optional. Associated metadata with the column such as a field.
	 * @param string|number $sorting_id Optional. Sorting identifier to use when passing to \GF_Query.
	 */
	public function __construct( $type, $meta = array(), $sorting_id = null ) {
		$this->type       = $type;
		$this->meta       = $meta;
		$this->sorting_id = $sorting_id;
	}

	/**
	 * Gets the CSS classes for the column as space-delimited string.
	 */
	public function get_css_classes() {
		$classes = array();

		if ( $this->type ) {
			$classes[] = "gpeb-table-column-{$this->type}";
		}

		if ( $this->sorting_id ) {
			$classes[] = 'gpeb-table-column-sortable';
		}

		if ( rgar( $this->meta, 'fieldId' ) ) {
			$field = GFAPI::get_field( $this->meta['form'], $this->meta['fieldId'] );

			if ( $field ) {
				$classes[] = "gpeb-table-column-field-{$field->id}";
				$classes[] = "gpeb-table-column-field-type-{$field->type}";
			}
		}

		return implode( ' ', $classes );
	}
}
