<?php
/***************************************** for input fields like text, numbers, email and website **************************************/

if (in_array($field->type, $input_fields)) {
	$input_classes_types = array( 'ginput_container_date', 'ginput_container_text', 'ginput_container_phone', 'ginput_container_email', 'ginput_container_website', 'ginput_container_post_title', 'ginput_container_number', 'ginput_container_name', 'ginput_container_product_price' );
	$instruction_classes = array( 'instruction' );

	$is_complex_field = false;
	$has_instruction = false;
    $contains_error = false;
    $contains_placeholder = false;
	$input_id = '';
	$field_container = '';
    $all_divs = $dom->getElementsByTagName('div');
    foreach ($all_divs as $current_div) {
        $current_div_classes = $current_div->getAttribute('class');
        if (strpos($current_div_classes, 'validation_message') !== false) {
            $contains_error = true;
            $current_div->setAttribute('class', $current_div->getAttribute('class') . ' mdc-text-field-helper-text mdc-text-field-helper-text--persistent mdc-text-field-helper-text--validation-msg');
        }
        if (strpos($current_div_classes, 'ginput_complex') !== false) {
            $is_complex_field = true;
        }
    }

    //if its not a complex field then do the modifications
    if ( ! $is_complex_field ) {
        //get the first div
        foreach ($all_divs as $div) {
            $div_classes = $div->getAttribute('class');

            $div_classes_array = explode(' ', $div_classes);

			//var_dump($div_classes_array);

            $is_valid_input_field = false;

            foreach ($div_classes_array as $div_class_value) {
                if (in_array($div_class_value, $input_classes_types)) {
                    $is_valid_input_field = true;
                    $field_container = $div;
                }
                
                if (in_array($div_class_value, $instruction_classes)) {

					$has_instruction = true;
					$instruction = $div;
					
                }
            }
            
            if ($is_valid_input_field) {

				// get icons
				$icons = $dom->getElementsByTagName('i');
				$icon_parent_class = '';
				foreach( $icons as $icon ) {
					$icon_classes = $icon->getAttribute('class');
					if ( strpos( $icon_classes, 'stla-fontawesome-icon') !== false) {
						$icon_parent_class = 'mdc-text-field--with-leading-icon';
						$icon->setAttribute('class', $icon->getAttribute('class') . ' mdc-text-field__icon');
					}
				}

                //add class to input
                $inputs = $dom->getElementsByTagName('input');
                foreach ($inputs as $input) {
                    $id = $input->getAttribute('id');

                    //$input_type = $input->getAttribute( 'type' );
                    if (preg_match('/^input_/', $id)) {

						$input_id = $id;

                        $input_classes = $input->getAttribute('class');
                        $input->setAttribute('class', $input_classes . ' mdc-text-field__input');

                        // check if contains placeholder
                        if ($input->getAttribute('placeholder') !== '' && $type !== 'outlined') {
                            $contains_placeholder = true;
                        }

                        //find the size of field
                        if (strpos($input_classes, 'large') !== false) {
                            $field_size_class = 'stla_material_large';
                        } elseif (strpos($input_classes, 'medium') !== false) {
                            $field_size_class = 'stla_material_medium';
                        } else {
                            $field_size_class = 'stla_material_small';
                        }
                    }
                }
                
                //add classes to div
				$add_div_classes = ' mdc-text-field ' . $field_size_class.' '.$icon_parent_class;
				
				// outlined design
				$add_div_classes .= $type === 'outlined' ?' mdc-text-field--outlined': '';

                //if has error then add the error class
                if ($contains_error) {
                    $add_div_classes .= ' mdc-text-field--invalid';
                }
                $div->setAttribute('class', $div->getAttribute('class') . $add_div_classes);
                $div->setAttribute('data-mdc-auto-init', 'MDCTextField');

                //get the first label
                $labels = $dom->getElementsByTagName('label');
                foreach ($labels as $label) {
                    $label_for = $label->getAttribute('for');


                    if ($input_id === $label_for) {
                        $add_label_classes = ' mdc-floating-label';
                       
                        if ($contains_placeholder) {
                            $add_label_classes .= ' mdc-floating-label--float-above';
                        }

                        // outlined design
                        if ($type === 'outlined') {
                            $notched_outline = $dom->createElement('div');
                            $notched_outline->setAttribute('class', 'mdc-notched-outline');

                            $notched_outline_leading = $dom->createElement('div');
                            $notched_outline_leading->setAttribute('class', 'mdc-notched-outline__leading');
                            
                            $notched_outline_notch = $dom->createElement('div');
                            $notched_outline_notch->setAttribute('class', 'mdc-notched-outline__notch');

                            $notched_outline_trailing = $dom->createElement('div');
                            $notched_outline_trailing->setAttribute('class', 'mdc-notched-outline__trailing');
                            
                            if ($contains_placeholder) {
                                $notched_outline->setAttribute('class', 'mdc-notched-outline mdc-notched-outline--notched');
                            }
                            $div->appendChild($notched_outline);

                            $notched_outline->appendChild($notched_outline_leading);
                            $notched_outline->appendChild($notched_outline_notch);
                            $notched_outline->appendChild($notched_outline_trailing);

                            $label->setAttribute('class', $label->getAttribute('class') . $add_label_classes);
                            $notched_outline_notch->appendChild($label);
                        } else { // Filled style
                            $label->setAttribute('class', $label->getAttribute('class') . $add_label_classes);
                            $div->appendChild($label);
                        }
                    }
                }
                
                //create a new div
                if ($type === 'filled') {
                    $bottom_line_div = $dom->createElement('div');
                    $bottom_line_div->setAttribute('class', 'mdc-line-ripple');
                    $div->appendChild($bottom_line_div);
                }
			}
		}

		//instructions for number field
		if ($has_instruction && '' !== $field_container) {

			$field_container->parentNode->appendChild($instruction);
		}
	}
	
	/**************************************** for single product ***************************************/

	foreach ($all_divs as $div) {
		$div_classes = $div->getAttribute('class');

		if ( strpos( $div_classes, 'ginput_container_singleproduct') !== false  ) {

			//get the first label
			$labels = $dom->getElementsByTagName('label');
			// foreach ($labels as $label ) { 
			// 	$label->setAttribute('class', $label->getAttribute('class') . ' mdc-floating-label mdc-floating-label--float-above stla-mat-top-label' );
			// }

			// for quantity label wrapped as span
			$spans = $dom->getElementsByTagName('span');
			foreach ($spans as $span ) {
				$span_classes = $span->getAttribute('class');
				if( strpos( $span_classes, 'ginput_quantity_label' ) !== false ) {
					$container = $dom->createElement( 'div' );
					$container->setAttribute( 'class', 'mdc-text-field' );
					$div->appendChild( $container );
					
					//add classes to div
					$add_div_classes = 'mdc-text-field stla_material_small';
					
					// outlined design
					$add_div_classes .= $type === 'outlined' ?' mdc-text-field--outlined': '';

					//if has error then add the error class
					if ($contains_error) {
						$add_div_classes .= ' mdc-text-field--invalid';
					}
					$container->setAttribute('class', $add_div_classes);
					$container->setAttribute('data-mdc-auto-init', 'MDCTextField');
							$add_label_classes = ' mdc-floating-label';

					//add class to input
					$inputs = $dom->getElementsByTagName('input');
					foreach ($inputs as $input) {
						$id = $input->getAttribute('id');

						//$input_type = $input->getAttribute( 'type' );
						if (preg_match('/^ginput_quantity_/', $id)) {

							$input_id = $id;

							$input_classes = $input->getAttribute('class');
							$input->setAttribute('class', $input_classes . ' mdc-text-field__input');
							$container->appendChild( $input );
						}
					}

					// outlined design
					if ($type === 'outlined') {
						$notched_outline = $dom->createElement('div');
						$notched_outline->setAttribute('class', 'mdc-notched-outline');

						$notched_outline_leading = $dom->createElement('div');
						$notched_outline_leading->setAttribute('class', 'mdc-notched-outline__leading');
						
						$notched_outline_notch = $dom->createElement('div');
						$notched_outline_notch->setAttribute('class', 'mdc-notched-outline__notch');

						$notched_outline_trailing = $dom->createElement('div');
						$notched_outline_trailing->setAttribute('class', 'mdc-notched-outline__trailing');
						
						$container->appendChild($notched_outline);

						$notched_outline->appendChild($notched_outline_leading);
						$notched_outline->appendChild($notched_outline_notch);
						$notched_outline->appendChild($notched_outline_trailing);

						$span->setAttribute('class', $span->getAttribute('class') . $add_label_classes);
						$notched_outline_notch->appendChild($span);
					} else { // Filled style
						$span->setAttribute('class', $span->getAttribute('class') . $add_label_classes);
						$container->appendChild($span);
					}

					//create a new div
				if ($type === 'filled') {
					$bottom_line_div = $dom->createElement('div');
					$bottom_line_div->setAttribute('class', 'mdc-line-ripple');
					$container->appendChild($bottom_line_div);
				}

				// Adding price label classes
				if( strpos( $span_classes, 'ginput_product_price_label' ) !== false ) {
					$span->setAttribute('class', $span_classes . ' mdc-typography--body1' );
				}

				// Adding price amount classes
				if( strpos( $span_classes, 'ginput_product_price_label' ) !== false ) {
					$span->setAttribute('class', $span_classes . ' mdc-typography--subtitle2' );
				}
			}
			
			}
		}
	}

    /***************************************** for postimage meta **************************************/

    $post_meta_input_types = array( 'ginput_post_image_title', 'ginput_post_image_caption', 'ginput_post_image_description' );
    $is_valid_post_meta = false;
    $spans = $dom->getElementsByTagName('span');
    foreach ($spans as $span) {
        $span_classes = $span->getAttribute('class');

        $span_classes_array = explode(' ', $span_classes);

        //var_dump($div_classes_array);

        $is_valid_input_field = false;

        foreach ($span_classes_array as $span_class_value) {
            if (in_array($span_class_value, $post_meta_input_types)) {
				$is_valid_post_meta = true;
            }
		}
		
		if( $is_valid_post_meta ){

			 //add classes to div
			 $add_span_classes = ' mdc-text-field stla_material_large';
			 $span->setAttribute('class', $span->getAttribute('class') . $add_span_classes);
			 $span->setAttribute('data-mdc-auto-init', 'MDCTextField');

			 $inputs = $span->getElementsByTagName('input');
			 foreach( $inputs as $input){
				$input_classes = $input->getAttribute('class');
				$input->setAttribute('class', $input_classes . ' mdc-text-field__input');
			 }
			 $labels = $span->getElementsByTagName('label');
			 $add_label_classes = ' mdc-floating-label';
                foreach ($labels as $label) {
                    $label->setAttribute('class', $label->getAttribute('class') . $add_label_classes);
				}
			 //create a new div
			 $bottom_line_div = $dom->createElement('div');
			 $bottom_line_div->setAttribute('class', 'mdc-line-ripple');
			 $span->appendChild($bottom_line_div);
		}
	}
	$content = utf8_decode($dom->saveHTML($dom->documentElement));
}