<?php

namespace GP_Entry_Blocks\Compatibility;

class GP_Populate_Anything {
	public function __construct() {
		if ( ! function_exists( 'gp_populate_anything' ) ) {
			return;
		}

		add_filter( 'gpeb_entry_form', array( $this, 'hydrate_choices' ), 10, 3 );
	}

	/**
	 * Hydrate the form choices using Populate Anything so choice labels show up correctly instead of the values.
	 *
	 * @param array $form
	 * @param array $entry
	 * @param \WP_Block $block
	 *
	 * @return array Form hydrated with choice labels.
	 */
	public function hydrate_choices( $form, $entry, $block ) {
		return gp_populate_anything()->modify_admin_field_choices( $form, false, $entry );
	}
}
