<?php
/***************************************** for complex fields like address and name *************************************/

if ( in_array( $field->type, $email_confirmation ) ) {
	//var_dump($content);

	$is_complex_field = false;
	$contains_error = false;

	//check if error is present
	$all_divs = $dom->getElementsByTagName( 'div' );
	foreach ( $all_divs as $current_div ) {
		$current_div_classes = $current_div->getAttribute( 'class' );
		if ( strpos( $current_div_classes, 'validation_message' ) !== false ) {
			$contains_error = true;
			$current_div->setAttribute( 'class', $current_div->getAttribute( 'class' ) . ' mdc-text-field-helper-text mdc-text-field-helper-text--persistent mdc-text-field-helper-text--validation-msg' );
		}

		if ( strpos( $current_div_classes, 'ginput_complex' ) !== false ) {
			$is_complex_field = true;
		}
	}
	// if its complex field only then process it.. ( added because of confirm email )
	if ( $is_complex_field  ) {
		$get_span = $dom->getElementsByTagName( 'span' );

		foreach ( $get_span as $input_element ) {

			$span_classes = $input_element->getAttribute( 'class' );

			//check if the current span is not 'required' * span
			if ( strpos( $span_classes, 'gfield_required' ) === false ) {
				//create a new div to append to span

				$container_div = $dom->createElement( 'div' );
				$container_div->setAttribute( 'class', 'MDCTextField' );
				$input_element->appendChild( $container_div );


				//get newly appended container div

				$container_div = $input_element->getElementsByTagName( 'div' )->item( 0 );
				$add_classes = $container_div->getAttribute( 'class' ). ' stla_material_large  mdc-text-field';
				// outlined design
				$add_classes .= $type === 'outlined' ?' mdc-text-field--outlined': '';

				if ( $contains_error ) {
					$add_classes .= ' mdc-text-field--invalid';
				}

				$container_div->setAttribute( 'class', $add_classes );
				$container_div->setAttribute( 'data-mdc-auto-init', 'MDCTextField' );

				$inputs = $input_element->getElementsByTagName( 'input' );
				foreach ( $inputs as $input ) {
					$input->setAttribute( 'class', $input->getAttribute( 'class' ) . '  mdc-text-field__input' );
					$container_div->appendChild( $input );
					$add_label_classes = ' mdc-floating-label';
					if ( $input->getAttribute( 'placeholder' ) !== ''  && $type !== 'outlined' ) {
						$add_label_classes .= ' mdc-floating-label--float-above';
					}
				}
				$labels = $input_element->getElementsByTagName( 'label' );
				foreach ( $labels as $label ) {

					// outlined design
					if( $type === 'outlined' ) {
						$notched_outline = $dom->createElement('div');
						$notched_outline->setAttribute( 'class', 'mdc-notched-outline' );

						$notched_outline_leading = $dom->createElement( 'div' );
						$notched_outline_leading->setAttribute( 'class', 'mdc-notched-outline__leading' );
						
						$notched_outline_notch = $dom->createElement( 'div' );
						$notched_outline_notch->setAttribute( 'class', 'mdc-notched-outline__notch' );

						$notched_outline_trailing = $dom->createElement( 'div' );
						$notched_outline_trailing->setAttribute( 'class', 'mdc-notched-outline__trailing' );
						
						if ($contains_placeholder) {
							$notched_outline->setAttribute( 'class', 'mdc-notched-outline mdc-notched-outline--notched' );
						}
						$container_div->appendChild( $notched_outline );

						$notched_outline->appendChild( $notched_outline_leading );
						$notched_outline->appendChild( $notched_outline_notch );
						$notched_outline->appendChild( $notched_outline_trailing );

						$label->setAttribute('class', $label->getAttribute( 'class' ) . $add_label_classes );
						$notched_outline_notch->appendChild( $label );
					}
					else{
						$label->setAttribute( 'class', $label->getAttribute( 'class' ) . $add_label_classes );
						$container_div->appendChild( $label );
					}
				}

				//create a new div
                if ($type === 'filled') {
                    $bottom_line_div = $dom->createElement('div');
                    $bottom_line_div->setAttribute('class', 'mdc-line-ripple');
                    $container_div->appendChild($bottom_line_div);
                }
			}
		}
	}
	$content = utf8_decode( $dom->saveHTML( $dom->documentElement ) );
}
