(function (Vue) {
  window.addEventListener("load", function (event) {
	const app = Vue.createApp({
	  data() {
		return {
		  buttonText: ''
		}
	  },
	  mounted() {
		this.buttonText = this.$el.parentElement.dataset['text'];
	  }
	});
	app.component('qal-info', {
	  props: ['title', 'link', 'password', 'postThumbnail', 'usageLimitLeft', 'expireTime', 'labels'],
	  template: '<div class="ppwp-qal-item">' +
		'<div class="ppwp-qal-item__image" v-if="postThumbnail && postThumbnail.length">' +
		'<a :href="link" target="_blank">' +
		'<img :src="postThumbnail[0]" :width="postThumbnail[1]" :height="postThumbnail[2]">' +
		'</a>' +
		'</div>' +
		'<div class="ppwp-qal-item__title" v-if="title">' +
		'{{ title }}' +
		'</div>' +
		'<div class="ppwp-qal-item__password" v-if="password">' +
		'<label>{{ labels.password_label }}</label>' +
		'<span>' +
		'{{ password }}' +
		'</span>' +
		'</div>' +
		'<div class="ppwp-qal-item__expiry-time" v-if="expireTime">' +
		'<label>{{ labels.password_expiry_label }}</label>' +
		'<span>' +
		'{{ expireTime }}' +
		'</span>' +
		'</div>' +
		'<div class="ppwp-qal-item__usage-limit" v-if="usageLimitLeft">' +
		'<label>{{ labels.usage_limit_label }}</label>' +
		'<span>' +
		'{{ usageLimitLeft }}' +
		'</span>' +
		'</div>' +
		'<div class="ppwp-qal-item__access-link" v-if="link">' +
		'<label>{{ labels.access_link_label }}</label>' +
		'<a :href="link" target="_blank">{{ $root.$data.buttonText }}</a>' +
		'</div>' +
		'</div>'
	});

	app.component('qal-list', {
	  props: {
		limit: Number,
		qals: Array,
		labels: Object,
	  },
	  data() {
		return {
		  page: 0
		}
	  },
	  computed: {
		pageQals() {
		  const offset = this.limit * this.page;
		  return this.qals ? this.qals.slice(offset, offset + this.limit) : [];
		},
		canNext() {
		  return (this.page + 1) * this.limit < this.qals.length;
		},
		canPrev() {
		  return this.page > 0;
		},
		totalPage() {
		  return Math.ceil(this.qals.length / this.limit);
		}
	  },
	  methods: {
		next(e) {
		  e.preventDefault();
		  this.page = this.page + 1;
		},
		prev(e) {
		  e.preventDefault();
		  this.page = this.page - 1;
		}
	  },
	  template: '<qal-info ' +
		'v-for="item in pageQals" ' +
		':key="item.id" ' +
		':title="item.title" ' +
		':link="item.link" ' +
		':password="item.password" ' +
		':postThumbnail="item.postThumbnail" ' +
		':usageLimitLeft="item.usageLimitLeft" ' +
		':expireTime="item.expireTime" ' +
		':labels="labels" ' +
		'/>' +
		'</div>' +
		'<div class="ppwp-qal-pagination">' +
		'<div class="ppwp-qal-pagination__action">' +
		'<a class="ppwp-qal-pagination__prev" href="#" v-if="canPrev" v-on:click="prev($event)">Prev</a>' +
		'<a class="ppwp-qal-pagination__next" href="#" v-if="canNext" v-on:click="next($event)">Next</a>' +
		'</div>' +
		'<div class="ppwp-qal-pagination__info">' +
		'<span class="ppwp-qal-pagination__current-page">' +
		'{{ page + 1 }}' +
		'</span>' +
		'<span class="ppwp-qal-pagination__divider">/</span>' +
		'<span class="ppwp-qal-pagination__total-page">' +
		'{{ totalPage }}' +
		'</span>' +
		'</div>'
	});

	app.mount('.ppwp-qal-list');
  });
})(Vue);
