<?php
$current_user          = wp_get_current_user();
$user_meta             = get_user_meta( get_current_user_id(), PPW_Pro_Constants::USER_SUBSCRIBE );
$should_show_al_banner = apply_filters( 'ppwp_sitewide_should_show_al_banner', true );
?>
<div class="ppwp_wrap_subscribe_form ppw_wrap_subscribe_form">
	<div class="ppwp_subscribe_form">
		<h3><?php echo __( 'What\'s news?', 'password-protect-page' ); ?></h3>
		<div style="padding-left: 15px;padding-right: 15px;">
			<ul style="list-style: disc;">
				<li>
					<?php echo __( '[New Feature] ', 'password-protect-page'); ?>
					<a target="_blank" rel="noopener" href="https://passwordprotectwp.com/docs/list-quick-access-links/?utm_source=user-website&utm_medium=sidebar-what-news&utm_campaign=ppwp-pro">
					<?php echo __( 'List all Quick Access Links', 'password-protect-page' ); ?></a> 
					<?php echo __( 'that each logged-in user clicks on ', 'password-protect-page' ); ?>
					(<a target="_blank" rel="noopener" href="https://passwordprotectwp.com/extensions/password-statistics/?utm_source=user-website&utm_medium=sidebar-what-news&utm_campaign=ppwp-pro">PPWP Statistics</a>
					<?php echo __(' is required).', 'password-protect-page' ); ?>
				</li>
				<li>
					<?php echo __( '[Improvement] Display license information under "License" tab.', 'password-protect-page' ); ?>
				</li>
				<li>
					<?php echo __( '[Improvement] Allow using ', 'password-protect-page' ); ?><a target="_blank" rel="noopener" href="https://passwordprotectwp.com/docs/master-passwords-unlock-all-protected-content/?utm_source=user-website&utm_medium=sidebar-what-news&utm_campaign=ppwp-pro">
					<?php echo __( 'Master passwords', 'password-protect-page' ); ?></a> 
					<?php echo __( ' to unlock Section Protection. ', 'password-protect-page' ); ?>
					 
				</li>
				<li>
					<?php echo __( '[Improvement] Whitelist custom user roles access to Partial Content Protection.', 'password-protect-page' ); ?>
				</li>
			</ul>
		</div>
	</div>
	<form id="ppwp_subscribe_form" class="ppwp_subscribe_form <?php echo empty( $user_meta ) ? '' : 'ppwp_subscribe_hidden'; ?>">
		<h3><?php echo esc_html( 'Feeling lucky?', 'password-protect-page' ); ?></h3>
		<p><?php echo esc_html( 'Be the first to get our latest updates and probably 1-year Pro license for free.', 'password-protect-page' ); ?></p>
		<input type="text" id="ppwp_email_subscribe" class="input_email" placeholder="you@example.com" value="<?php echo esc_attr( $current_user->user_email ); ?>"/>
		<input type="hidden" id="ppwp_subscribe_form_nonce" value="<?php echo wp_create_nonce( PPW_Pro_Constants::SUBSCRIBE_FORM_NONCE ); ?>">
		<p class="ppwp_subscribe_error"><?php echo esc_html( 'Please enter your valid email.', 'password-protect-page' ); ?></p>
		<p><input type="submit" class="button button-primary" id="ppwp_subscribe_button" value="<?php echo esc_html( 'Get Lucky', 'password-protect-page' ); ?>"/></p>
	</form>
	<div id="ppwp_subscribe_form_success" class="ppwp_subscribe_form <?php echo empty( $user_meta ) ? 'ppwp_subscribe_hidden' : ''; ?>">
		<p><?php echo esc_html( 'Congrats! You\'ve subscribed to our newsletter and now stand a chance to win our 1-year Pro license for free.', 'password-protect-page' ); ?></p>
		<p><?php echo esc_html( 'Stay tuned for our updates :)', 'password-protect-page' ); ?></p>
	</div>
	<?php
		if ( $should_show_al_banner ) {
			?>
			<div class="ppwp_wrap_al">
				<a target="_blank" rel="noopener" href="http://bit.ly/pro-membership">
					<img src="<?php echo PPW_PRO_DIR_URL; ?>admin/images/ppwp-membership.png"/>
				</a>
			</div>
			<?php
		}
	?>
</div>
