<?php
$configs              = require( PPW_PRO_DIR_PATH . 'includes/class-ppw-pro-configs.php' );
$license_service      = new PPW_Pro_License_Services();
$license_key          = get_option( PPW_Pro_Constants::LICENSE_KEY, '' );
$license_type         = $license_service->get_license_type();
$is_entered_license   = $license_service->is_valid_license();
$should_display_input = $configs->debug_mode;
if ( $license_service->should_display_license_input() ) {
	$should_display_input = true;
}
?>
<div class="ppw_main_container">
	<form id="wp_protect_password_license_form" class="wppp-license-container">
		<?php
		ppw_render_license_header( $is_entered_license, $license_type, $license_key );
		ppw_render_license_form( $is_entered_license, $should_display_input );
		ppwp_license_render_addons( $is_entered_license );
		if ( ! $is_entered_license || $should_display_input ) {
			submit_button();
		}
		?>
	</form>
</div>

<?php
function ppw_render_license_header( $is_entered_license, $license_type, $license_key = '' ) {
	if ( ! $is_entered_license ) { ?>
		<h3><?php echo esc_html( PPW_Pro_Constants::LICENSE_NOT_ACTIVATED ); ?></h3>
	<?php } else {?>
		<div class="wppp-license-info">
			<label>PPWP Pro</label>
			<span>
				<i class="ppw-icon-star dashicons dashicons-star-filled" aria-hidden="true"></i>
				<?php echo sprintf( __( 'Pro version %s', 'password-protect-page' ), PPW_PRO_VERSION ); ?>
			</span>
		</div>
		<div class="wppp-license-info">
			<label><?php _e( 'License type', 'password-protect-page' ); ?></label>
			<span><?php echo esc_html( $license_type ); ?></span>
		</div>
		<div class="wppp-license-info">
			<label><?php _e( 'License key', 'password-protect-page' ); ?></label>
			<span><?php echo esc_html( $license_key ); ?></span>
			<?php if (ppw_core_get_setting_type_bool( PPW_Pro_Constants::WPP_DEBUG_LOG_ENABLED ) ): ?>
			<a id="ppwp-refresh-license" style="cursor: pointer;"><?php _e( '(Refresh license)', 'password-protect-page' ); ?></a>
			<?php endif;?>
		</div>
	<?php }
}

function ppw_render_license_form( $is_entered_license, $should_display_input ) {
	if ( $is_entered_license && ! $should_display_input ) {
		return '';
	}

	if ( $is_entered_license ): ?>
		<div class="wppp-license-info">
			<label><?php _e( 'Select a new license type', 'password-protect-page' ); ?></label>
			<td>
				<select name="product_id" id="product_id" form="pda_license_form">
					<option value="77808414">3-site yearly subscription license</option>
					<option value="78043506">10-site yearly subscription license</option>
					<option value="78043507">15-site yearly subscription license</option>
					<option value="78022875">3-site lifetime license</option>
					<option value="78043526">10-site lifetime license</option>
					<option value="78043515">15-site lifetime license</option>
				</select>
			</td>
		</div>
	<?php endif; ?>
	<div class="wppp-license-info">
		<input type="hidden" value="<?php echo wp_create_nonce( PPW_Pro_Constants::LICENSE_FORM_NONCE ); ?>"
		       id="ppw_license_nonce"/>
		<label><?php _e( 'Input a new license key', 'password-protect-page' ); ?></label>
		<td>
			<input required style="width: 330px" type="text" id="wp-protect-password-gold_license_key"
			       name="wp-protect-password-gold_license_key" value=""/>
		</td>
	</div>
	<?php
}

function ppwp_license_render_addons( $is_entered_license ) {
	if ( $is_entered_license ) {
		$license_service = new PPW_Pro_License_Services();
		$license_info    = $license_service->get_license_info();
		$addons          = ppw_pro_get( $license_info, 'addons', [] );
		$addons_text     = $license_service->convert_addons_to_string( $addons );
		if ( empty( $addons ) ) {
			return '';
		}

		?>
		<div class="wppp-license-info purchased-addons">
			<label><?php echo esc_html__( 'Purchased addons', 'password-protect-page' ) ?></label>
			<span style="vertical-align: top;max-width: 60%; display: inline-block"><?php echo esc_html( $addons_text ) ?></span>
		</div>
	<?php }
}

$assert_services = new PPW_Pro_Asset_Services( get_current_screen()->id, $_GET );
$assert_services->load_asset_for_license_tab();
?>
