(function ($) {
    'use strict';
  	var pluginName = ppw_license_data.plugin_name;
    $(function () {
        $('#wp_protect_password_license_form').submit(function (evt) {
            evt.preventDefault();
            var license = $('#wp-protect-password-gold_license_key').val();
            _checkLicense(license, function (result, error) {
                $('#submit').val('Save Changes');
                $("#submit").prop("disabled", false);
                if (result) {
                    toastr.success(result.message, pluginName);
                    location.reload(true);
                }

                if (error) {
                    if (400 === error.status) {
                        toastr.error(error.responseJSON.message, pluginName);
                    } else {
                        toastr.error('License invalid!', pluginName);
                    }
                    console.log('Data error', error);
                }
            });
        });
        $('#ppwp-refresh-license').click(function(evt) {
          	evt.preventDefault();
		  	_recheckLicense($(this));
		});
    });

    function _checkLicense(license, cb) {
        var _data = {
            action: 'ppw_pro_check_license',
            license: license.trim(),
		  	product_id: $("#product_id").val(),
		  	security_check: $("#ppw_license_nonce").val(),
        }
        $('#submit').val('Submitting');
        $("#submit").prop("disabled", true);
        $.ajax({
            url: ppw_license_data.ajax_url,
            type: 'POST',
            data: _data,
            success: function (res) {
                cb(res, null);
            },
            error: function (error) {
                $("#submit").prop("disabled", false);
                cb(null, error);
            }

        })
    }

    function _recheckLicense($recheckLicenseButton) {
	  var _data = {
		action: 'ppwp_recheck_license',
		security_check: $("#ppw_license_nonce").val(),
	  };
	  $recheckLicenseButton.text('(Refreshing...)');
	  $.ajax({
		url: ppw_license_data.ajax_url,
		type: 'POST',
		data: _data,
		success: function (data) {
		  if (data.success) {
			toastr.success(data.message, pluginName);
			return;
		  }
		  if (data.message) {
			toastr.error(data.message, pluginName);
			return;
		  }
		  toastr.error('Oops! Please try again or contact the plugin owner.', pluginName);
		},
		error: function (error) {
		  toastr.error('Oops! Please try again or contact the plugin owner.', pluginName);
		},
		complete: function () {
		  $recheckLicenseButton.text('(Refresh license)');
		  location.reload();
		}
	  });
	}
})(jQuery);
