<?php
// var_dump($password_label);
function entire_site_render_login_form() {

	$logo_content        = wp_kses_post( get_theme_mod( 'ppwp_pro_form_logo_content', PPW_Pro_Constants::DEFAULT_CONTENT_TEXT ) );
	$password_label      = wp_kses_post( get_theme_mod( 'ppwp_pro_form_instructions_password_label', __( 'Password:', 'password-protect-page' ) ) );
	$error_message       = wp_kses_post( get_theme_mod( 'ppwp_pro_form_error_message_text', __( 'Please enter the correct password!', 'password-protect-page' ) ) );
	$password_placehoder = wp_kses_post( get_theme_mod( 'ppwp_pro_form_instructions_placeholder', PPW_Pro_Constants::DEFAULT_PLACEHOLDER ) );
	$button_text         = wp_kses_post( get_theme_mod( 'ppwp_pro_form_button_label', __( 'Enter', 'password-protect-page' ) ) );
	$show_password_text  = wp_kses_post( get_theme_mod( 'ppwp_pro_form_instructions_show_password_text', __( 'Show password', 'password-protect-page' ) ) );
	$show_password       = get_theme_mod( 'ppwp_pro_form_instructions_is_show_password', PPW_Pro_Constants::DEFAULT_IS_SHOW_PASSWORD ) ? '<div class="ppw-show-password"><label><input type="checkbox" onclick="ppwShowSiteWidePassword()">' . _x( $show_password_text, PPW_Pro_Constants::CONTEXT_PASSWORD_FORM, 'password-protect-page' ) . '</label></div>' : '';
	$disable_logo        = get_theme_mod( 'ppwp_pro_logo_disable', PPW_Pro_Constants::DEFAULT_LOGO_CUSTOMIZE_DISABLE ) ? 'none' : 'block';
	$form_transparency   = get_theme_mod( 'ppwp_pro_form_enable_transparency', PPW_Pro_Constants::DEFAULT_FORM_TRANSPARENCY ) ? 'style="background: none!important; box-shadow: initial;"' : '';
	$is_wrong_password   = isset( $_GET['action'] ) && $_GET['action'] === 'ppw_postpass' && isset( $_POST['input_wp_protect_password'] ) ? 'display: block' : 'display: none';
	$below_desc          = wp_kses_post( get_theme_mod( 'ppwp_pro_form_below_desc_text' ) ) ? '<div class="ppw-form-below-desc">' . wp_kses_post( get_theme_mod( 'ppwp_pro_form_below_desc_text' ) ) . '</div>' : '';
	$action              = apply_filters( 'ppwp_sitewide_form_action', '?action=ppw_postpass' );

	$show_remember_me = ppw_pro_allowed_display_sitewide_remember_me();
	$remember_me      = '';
	$password         = '';
	if ( $show_remember_me ) {
		$remember_me = '<p class="ppw-remember-me"><label><input name="ppw_sitewide_remember_me" type="checkbox" value="1">' . __( get_theme_mod( 'ppwp_pro_show_remember_me_text', PPW_Pro_Constants::DEFAULT_REMEMBER_ME_TEXT ), 'password-protect-page-pro' ) . '</label></p>';
		$password    = isset( $_COOKIE['ppwp_sitewide_pwd_remember'] ) ? $_COOKIE['ppwp_sitewide_pwd_remember'] : '';
	}

	$script_show_password = '';
	if ( ! empty( $show_password ) ) {
		ob_start();
		do_action( PPW_Pro_Constants::HOOK_CUSTOM_SCRIPT_FORM_ENTIRE_SITE );
		$script = ob_get_contents();
		ob_end_clean();

		$script_show_password = '<script>' . $script . '</script>';
	}

	ob_start();
	do_action( 'ppwp_sitewide_above_submit_button' );
	$content_below_form = ob_get_clean();

	$is_wrong_password = apply_filters( 'ppwp_sitewide_error_message_enabled', $is_wrong_password );
	$error_message     = apply_filters( 'ppwp_sitewide_error_message', $error_message );

	$inputs = [
		'<label for="input_wp_protect_password">' . $password_label . '</label> <input class="input_wp_protect_password" type="password" id="input_wp_protect_password" name="input_wp_protect_password" placeholder="' . $password_placehoder . '" value="' . $password . '" >',
		$show_password,
		$remember_me,
		'<div style="' . $is_wrong_password . '" id="ppw_entire_site_wrong_password" class="ppw-entire-site-password-error">' . $error_message . '</div>',
		$content_below_form,
		'<input id="submit" type="submit" class="button button-primary button-login" value="' . $button_text . '">',
		$below_desc,
	];

	$inputs = apply_filters( 'ppwp_sitewide_form_fields', $inputs );

	return '
			<div class="pda-form-login ppw-swp-form-container">
				<a style="display: ' . $disable_logo . ' " title=" ' . esc_attr__( 'This site is password protected by PPWP plugin', 'password-protect-page' ) . '" class="ppw-swp-logo">' . PPW_PRO_NAME . ' plugin</a>
				<div class="pda-form-headline">' . $logo_content . '</div>
				<form ' . $form_transparency . ' action="' . $action . '" method="post">
					' . implode( PHP_EOL, $inputs ) . '
				</form>
			</div>' . $script_show_password;
}

?>
