<?php
$checked = ppw_pro_get_advanced_option( PPW_Pro_Constants::ADVANCED_USING_PAGINATION ) ? 'checked' : '';
$message = array(
	'label'       => 'Get Passwords in Batches',
	'description' => 'By default, PPWP retrieves all passwords to display on the Password Management pop-up. This might cause a timeout error when you have a huge number of passwords per post. Turn on this option to load the passwords in batches instead.'
);

?>
<form id="ppwp_advanced_form">
	<input type="hidden" id="ppwp_advanced_form_nonce"
	       value="<?php echo wp_create_nonce( PPW_Constants::GENERAL_FORM_NONCE ); ?>"/>
	<table class="ppwp_settings_table" cellpadding="4">
		<tr>
			<td>
				<label class="pda_switch" for="<?php echo PPW_Pro_Constants::ADVANCED_USING_PAGINATION; ?>">
					<input type="checkbox"
					       id="<?php echo PPW_Pro_Constants::ADVANCED_USING_PAGINATION; ?>" <?php echo esc_attr( $checked ); ?>/>
					<span class="pda-slider round"></span>
				</label>
			</td>
			<td>
				<p>
					<label>
						<?php echo esc_html__( $message['label'] ) ?>
					</label>
					<?php echo _e( $message['description'] ) ?>
				</p>
			</td>
		</tr>
		<tr>
			<td></td>
			<td><input id="advanced-submit" class="button button-primary" type="submit" value="Save Changes"></td>
		</tr>
	</table>
</form>
