(function ($) {
  'use strict';
  const pluginName = 'Password Protect WordPress';

  $(function () {
	$('#ppwp_advanced_form').submit(function(e) {
	  e.preventDefault();
	  const data = getDataFromClient();

	  _updateSettings(data, function(result, error) {
		if (result) {
		  toastr.success('Your settings have been updated successfully!', pluginName);
		  location.reload(true);
		}

		if (error) {
		  if (400 === error.status) {
			toastr.error(error.responseJSON ? error.responseJSON.message: 'Oops, Something Went Wrong', pluginName);
		  } else {
			toastr.error('Update settings fail!', pluginName);
		  }
		  console.log('Data error', error);
		  $("#advanced-submit").prop("disabled", false);
		}
	  });
	})

	function getDataFromClient() {
	  const results = {
		ppwp_using_pagination: $("#ppwp_using_pagination").prop('checked'),
	  };

	  console.log(results);

	  return results;
	}

	function _updateSettings(settings, cb) {
	  var _data = {
		action: 'ppwp_update_advanced_setting',
		settings: settings,
		security_check: $("#ppwp_advanced_form_nonce").val(),
	  };
	  $("#advanced-submit").prop("disabled", true);
	  ajaxRequest(_data, cb);
	}

	function ajaxRequest(_data, cb) {
	  $.ajax({
		url: ppw_misc_data.ajax_url,
		type: 'POST',
		data: _data,
		timeout: 5000,
		success: function (data) {
		  cb(data, null);
		},
		error: function (error) {
		  cb(null, error);
		},
	  });
	}
  });
})(jQuery);
