<?php

class PPW_PRO_WPML {

	/**
	 * Instance of PPWP_WPML class.
	 *
	 * @var PPW_PRO_WPML
	 */
	protected static $instance = null;

	/**
	 * Get instance.
	 *
	 * @return PPW_PRO_WPML
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function register() {
		if ( ! defined( 'ICL_SITEPRESS_VERSION' ) ) {
			return;
		}

		add_filter( 'ppwp_has_perm_edit_post', array( $this, 'has_perm_edit_post' ), 10, 2 );
		add_filter( 'ppwp_show_metabox_warn', array( $this, 'show_metabox_warn' ), 10, 2 );
		add_filter( 'ppwp_is_show_metabox_warning', array( $this, 'is_show_metabox_warning' ), 10, 2 );
		add_filter( 'ppwp_metabox_warn_message', array( $this, 'get_metabox_warn_message' ) );
		add_filter( 'ppwp_parent_id', array( $this, 'get_main_language_post_id' ), 10 );
	}

	/**
	 * Should use main language in WPML.
	 *
	 * @return boolean
	 */
	public function should_use_main_language() {
		return apply_filters( 'ppwp_wpml_using_main_language', true );
	}

	/**
	 * Is sub language.
	 *
	 * @param integer $post_id Post ID
	 *
	 * @return bool
	 */
	public function is_sub_lang_page( $post_id ) {
		global $wpml_post_translations;

		$default              = wpml_get_default_language();
		$source_language_code = $wpml_post_translations->get_element_lang_code( $post_id );

		return $default !== $source_language_code;
	}

	/**
	 * Has permission to edit post
	 *
	 * @param boolean $has_perm Has permission
	 * @param integer $post_id  Post ID.
	 *
	 * @return boolean
	 */
	public function has_perm_edit_post( $has_perm, $post_id ) {
		if ( ! $this->should_use_main_language() ) {
			return $post_id;
		}

		global $wpml_post_translations;

		$default              = wpml_get_default_language();
		$source_language_code = $wpml_post_translations->get_element_lang_code( $post_id );

		return $default === $source_language_code;
	}

	/**
	 * Show metabox warning message.
	 *
	 * @param boolean $is_show Is show meta box
	 * @param integer $post_id Post ID
	 *
	 * @return bool|int
	 */
	public function show_metabox_warn( $is_show, $post_id ) {
		if ( ! $this->should_use_main_language() ) {
			return $is_show;
		}

		if ( $is_show ) {
			return $is_show;
		}

		return $this->is_sub_lang_page( $post_id );
	}

	public function is_show_metabox_warning( $is_show, $post_id ) {
		if ( ! $this->should_use_main_language() ) {
			return $is_show;
		}

		if ( $is_show ) {
			return $is_show;
		}

		if ( ! defined( 'ICL_SITEPRESS_VERSION' ) ) {
			return $post_id;
		}

		if ( ppw_is_edit_page( 'new' ) && defined( 'ICL_LANGUAGE_CODE' ) ) {
			$default_lang = wpml_get_default_language();

			return ICL_LANGUAGE_CODE !== $default_lang;
		}

		return $this->is_sub_lang_page( $post_id );
	}

	/**
	 * Show metabox warning message.
	 *
	 * @param string $message
	 *
	 * @return string
	 */
	public function get_metabox_warn_message( $message ) {
		if ( ! $this->should_use_main_language() ) {
			return $message;
		}

		return __( 'Please manage passwords on parent page or default language page.', 'password-protect-page' );
	}

	/**
	 * Get main language post ID.
	 *
	 * @param integer $post_id Post ID.
	 *
	 * @return integer
	 */
	public function get_main_language_post_id( $post_id ) {
		if ( ! $this->should_use_main_language() ) {
			return $post_id;
		}

		global $wpml_post_translations;

		$default              = wpml_get_default_language();
		$source_language_code = $wpml_post_translations->get_element_lang_code( $post_id );
		if ( $default === $source_language_code ) {
			return $post_id;
		}

		$correct_id = $wpml_post_translations->element_id_in( $post_id, $default );

		return $correct_id;
	}
}
