<?php

if ( ! class_exists( 'PPW_Pro_Sitewide_Settings' ) ) {
	class PPW_Pro_Sitewide_Settings {
		/**
		 * Render UI sitewide submenu settings page
		 */
		public function render_ui() {
			?>
			<div class="wrap">
				<div id="icon-themes" class="icon32"></div>
				<h2>
					<?php echo esc_html__( 'Password Protect WordPress Pro: Sitewide Protection', 'password-protect-page' ); ?>
				</h2>

				<?php
				$general_tab   = apply_filters( PPW_Constants::HOOK_DEFAULT_TAB, 'general' );
				$activated_tab = isset( $_GET['tab'] ) ? $_GET['tab'] : $general_tab;
				$this->render_tabs( $activated_tab );
				$this->render_content( $activated_tab );
				?>
			</div>
			<?php
		}

		/**
		 * Render tab for sitewide page
		 *
		 * @param string $active_tab Activate tab
		 */
		public function render_tabs( $active_tab ) {
			$tabs = apply_filters(
				PPW_Constants::HOOK_ADD_NEW_SITEWIDE_SUBMENU,
				array(
					array(
						'tab'      => 'general',
						'tab_name' => 'General',
					),
				)
			);
			?>
			<h2 class="ppwp_wrap_tab_title nav-tab-wrapper">
				<?php
				if ( ! is_array( $tabs ) ) {
					return;
				}

				foreach ( $tabs as $tab ) {
					if ( ! is_array( $tab ) ) {
						continue;
					}

					if ( empty( $tab['tab'] ) || empty( $tab['tab_name'] ) ) {
						continue;
					}
					?>
					<a href="?page=<?php echo esc_html( PPW_Constants::SITEWIDE_PAGE_PREFIX ); ?>&tab=<?php echo esc_attr( $tab['tab'] ); ?>"
					   class="nav-tab <?php echo $active_tab === $tab['tab'] ? 'nav-tab-active' : ''; ?>"><?php _e( $tab['tab_name'], PPW_Constants::DOMAIN ); ?></a>
				<?php } ?>
			</h2>
			<?php
		}

		/**
		 * Render content for activate tab.
		 *
		 * @param $active_tab
		 */
		public function render_content( $active_tab ) {
			switch ( $active_tab ) {
				case 'general':
					$this->render_sitewide_submenu();
					break;
			}
		}

		/**
		 * Render general tab on for sw submenu
		 */
		public function render_sitewide_submenu() {
			?>
			<div class="ppwp_setting_page">
				<?php
				require_once PPW_PRO_VIEW_PATH . 'entire-site/view-ppw-pro-entire-site.php';
				require_once PPW_PRO_VIEW_PATH . 'sidebar/view-ppw-pro-sidebar.php';
				?>
			</div>
			<?php
		}
	}
}
