<?php

if ( ! class_exists( 'PPW_Pro_Single_Form_Customizer_Service' ) ) {
	class PPW_Pro_Single_Form_Customizer_Service {

		/**
		 * Instance of PPW_Pro_Single_Form_Customizer_Service class.
		 *
		 * @var PPW_Pro_Single_Form_Customizer_Service
		 */
		protected static $instance = null;

		/**
		 * Constructor for PPW_Pro_Single_Form_Customizer_Service
		 */
		public function __construct() {
			add_filter( 'ppw_customize_after_text_color', array( $this, 'ppwp_single_form_customize_register' ) );
			add_action( 'wp_head', array( $this, 'dynamic_styles' ) );
		}

		/**
		 * Get instance of PPW_Pro_Single_Form_Customizer_Service
		 *
		 * @return PPW_Pro_Single_Form_Customizer_Service
		 */
		public static function get_instance() {
			if ( is_null( self::$instance ) ) {
				self::$instance = new static();
			}

			return self::$instance;
		}

		/**
		 * Register customizer fields
		 *
		 * @param $wp_customize
		 */
		public function ppwp_single_form_customize_register( $wp_customize ) {
			$wp_customize->add_setting( 'ppwp_form_instructions_description_below_title' );

			$wp_customize->add_control(
				new PPW_Title_Group_Control(
					$wp_customize,
					'ppwp_form_instructions_description_below_title',
					array(
						'label'    => __( 'Description Below Form', 'password-protect-page' ),
						'section'  => 'ppwp_form_instructions',
						'settings' => 'ppwp_form_instructions_description_below_title',
						'type'     => 'control_title',
					)
				)
			);

			/* instructions text */
			$wp_customize->add_setting( 'ppwp_form_instructions_below_text' );

			$wp_customize->add_control(
				new PPW_Text_Editor_Custom_Control(
					$wp_customize,
					'ppwp_form_instructions_below_text',
					array(
						'label'    => __( 'Description', 'password-protect-page' ),
						'section'  => 'ppwp_form_instructions',
						'settings' => 'ppwp_form_instructions_below_text',
						'type'     => 'textarea',
					)
				)
			);

			/* instructions font size */
			$wp_customize->add_setting( 'ppwp_form_instructions_below_text_font_size' );

			$wp_customize->add_control(
				'ppwp_form_instructions_below_text_font_size_control',
				array(
					'label'       => __( 'Description Font Size', 'password-protect-page' ),
					'description' => __( 'Font size in px', 'password-protect-page' ),
					'section'     => 'ppwp_form_instructions',
					'settings'    => 'ppwp_form_instructions_below_text_font_size',
					'type'        => 'number',
			) );

			/* instructions font weight */
			$wp_customize->add_setting( 'ppwp_form_instructions_below_text_font_weight' );

			$wp_customize->add_control(
				'ppwp_form_instructions_below_text_font_weight_control',
				array(
					'label'    => __( 'Description Font Weight', 'password-protect-page' ),
					'section'  => 'ppwp_form_instructions',
					'settings' => 'ppwp_form_instructions_below_text_font_weight',
					'type'     => 'number',
			) );

			/* text color - form instructions */
			$wp_customize->add_setting( 'ppwp_form_instructions_below_text_color' );

			$wp_customize->add_control(
				new \WP_Customize_Color_Control(
					$wp_customize,
					'ppwp_form_instructions_below_text_color_control',
					array(
						'label'    => __( 'Description Text Color', 'password-protect-page' ),
						'section'  => 'ppwp_form_instructions',
						'settings' => 'ppwp_form_instructions_below_text_color',
					)
				)
			);
		}

		public function dynamic_styles() {
			$desc_font_size   = get_theme_mod( 'ppwp_form_instructions_below_text_font_size' );
			$desc_font_weight = get_theme_mod( 'ppwp_form_instructions_below_text_font_weight' );
			$desc_color       = get_theme_mod( 'ppwp_form_instructions_below_text_color' );

			$customizer_style = "
			.ppw-ppf-desc-below {
                font-size: " . $desc_font_size . "px!important;
				font-weight: " . $desc_font_weight . "!important;
				color: " . $desc_color . "!important;
            }
			";

			// Compress CSS - remove space and line break.
			$customizer_style = preg_replace( '/\s{2,}/', ' ', str_replace( '\n', '', str_replace( ', ', ',', $customizer_style ) ) );

			echo '<style id="ppwp_single_form">' . $customizer_style . '</style>';
		}

	}
}
