<?php

class PPWP_Recaptcha {
	private $recaptcha;

	public function __construct() {
		if ( class_exists( 'PPW_Recaptcha' ) ) {
			$this->recaptcha = new PPW_Recaptcha();
		}
	}

	/**
	 * @var PPWP_Recaptcha
	 */
	protected static $instance;

	/**
	 * @return PPWP_Recaptcha
	 */
	public static function get_instance() {
		if ( null == self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function compatibility_with_free() {
		if ( ! defined( 'PPW_VERSION' ) ) {
			return false;
		}

		return version_compare( PPW_VERSION, '1.7.4', '>=' );
	}

	/**
	 * Register hooks.
	 * @since 1.0.0
	 */
	public function register() {
		// Only apply hook with Free > 1.7.4
		if ( ! $this->compatibility_with_free() ) {
			return;
		}

		if ( is_null( $this->recaptcha ) ) {
			return;
		}

		if ( method_exists( $this->recaptcha, 'maybe_add_recaptcha_input_below_sitewide_form' ) ) {
			add_action( 'ppwp_sitewide_above_submit_button',
				array(
					$this->recaptcha,
					'maybe_add_recaptcha_input_below_sitewide_form',
				),
				20
			);
		}

		if ( method_exists( $this->recaptcha, 'maybe_load_sitewide_recaptcha_js' ) ) {
			add_action( 'ppwp_sitewide_footer',
				array(
					$this->recaptcha,
					'maybe_load_sitewide_recaptcha_js',
				),
				20
			);
		}

		if ( method_exists( $this->recaptcha, 'customize_sitewide_css' ) ) {
			add_action( 'ppw_custom_style_form_entire_site', array( $this->recaptcha, 'customize_sitewide_css' ), 10 );
		}


		add_filter( 'ppwp_sitewide_is_valid_password', array( $this, 'validate_sitewide_password' ), 10 );
		add_action( 'ppwp_sitewide_shortcode_after_enqueue_script', array( $this, 'load_recaptcha_js_in_footer' ), 10 );
	}

	/**
	 * Validate sitewide password form.
	 *
	 * @param boolean $validated Validated sitewide password.
	 *
	 * @return bool
	 */
	public function validate_sitewide_password( $validated ) {
		if ( ! $validated ) {
			return $validated;
		}

		if ( ! method_exists( $this->recaptcha, 'using_sitewide_recaptcha' ) || ! method_exists( $this->recaptcha, 'is_valid_recaptcha' ) ) {
			return $validated;
		}

		if ( ! $this->recaptcha->using_sitewide_recaptcha() ) {
			return $validated;
		}

		if ( ! $this->recaptcha->is_valid_recaptcha() ) {
			add_filter( 'ppwp_sitewide_error_message_enabled', '__return_true' );
			add_filter( 'ppwp_sitewide_error_message', array( $this->recaptcha, 'get_sitewide_error_message' ) );

			return false;
		}

		return $validated;
	}

	/**
	 * Load JS in footer.
	 */
	public function load_recaptcha_js_in_footer() {
		add_action( 'wp_footer', function () {
			if ( ! $this->recaptcha->using_sitewide_recaptcha() ) {
				return;
			}

			$this->recaptcha->add_recaptcha_to_head();
		} );
	}
}
