<?php
/**
 * Created by PhpStorm.
 * User: gaupoit
 * Date: 7/23/19
 * Time: 11:23
 */

if ( ! class_exists( 'PPW_Pro_License_Services' ) ) {

	class PPW_Pro_License_Services extends PPW_Pro_Base_Services {

		/**
		 * Get add-on's Name.
		 *
		 * @param int $id The add-on ID.
		 *
		 * @return string The add-on name
		 */
		public static function addons( $id ) {
			switch ( $id ) {
				case '78212818':
					return 'Password Suite';
				case '78144912':
					return 'Group Protection';
				case '78162557':
					return 'Access Levels';
				case '78244471':
					return 'WooCommerce Integration';
				case '78274346':
					return 'Forms Integration';
				case '77861101':
					return 'ActiveCampaign Integration';
				case '77998653':
					return 'MailChimp Integration';
				case '78274349':
					return 'Smart Restriction';
				case '78432034':
					return 'Passwordless Authentication';
				case '77838452':
					return 'Multisite Integration';
				case '77805157':
					return 'Statistics Integration';
				default:
					return '';
			}
		}

		public static function get_instance() {
			if ( null === self::$instance ) {
				self::$instance = new PPW_Pro_License_Services();
			}

			return self::$instance;
		}
		/**
		 *
		 * @return bool
		 */
		public function is_valid_license() {
			$license_key      = get_option( PPW_Pro_Constants::LICENSE_KEY, '' );
			$is_valid_license = get_option( PPW_Pro_Constants::LICENSE_OPTIONS );

			return ! empty( $license_key ) && ( '1' === $is_valid_license || true === $is_valid_license );
		}

		/**
		 * @param $request
		 */
		public function check_license( $request ) {
			if ( ppw_pro_is_data_invalid( $request, PPW_Pro_Constants::LICENSE_FORM_NONCE, PPW_Pro_Constants::DATA_LICENSE ) ) {
				send_json_data_error( __( PPW_Constants::BAD_REQUEST_MESSAGE, 'password-protect-page' ) );
			}

			if ( ! empty( $_REQUEST['product_id'] ) ) {
				$product_id = $_REQUEST['product_id'];
			} else {
				$product_id = get_site_option( PPW_Pro_Constants::APP_ID );
			}

			$license = $request['license'];
			if ( empty( $license ) ) {
				send_json_data_error( __( 'Please enter the correct license!', 'password-protect-page' ) );
			}
			$result  = YME_LICENSE::checkLicense( $license, 'wpp', $product_id );
			$data    = $result['data'];
			if ( ! $data ) {
				send_json_data_error( __( "There is something's wrong. Please <a href=\"hello@preventdirectaccess.com\">contact</a> the plugin owner!", 'password-protect-page' ) );
			}

			if ( is_object( $data ) && property_exists( $data, 'errorMessage' ) ) {
				send_json_data_error( __( $data->errorMessage, 'password-protect-page' ) );
			}

			update_option( PPW_Pro_Constants::LICENSE_KEY, $license );
			update_option( PPW_Pro_Constants::LICENSE_OPTIONS, true );
			update_option( PPW_Pro_Constants::LICENSE_ERROR, '' );
			update_site_option( PPW_Pro_Constants::APP_ID, $product_id );
			$this->update_license_info();

			delete_option( 'ppwp_update_info' );
			delete_option( 'ppwp_ls_error_message' );

			global $migration_service;
			$migration_service->start_run();

			wp_send_json( array(
				'is_error' => false,
				'message'  => __( 'Your settings have been updated successfully!', 'password-protect-page' )
			) );
			wp_die();
		}

		public function remove_license() {
			return delete_option( PPW_Pro_Constants::LICENSE_KEY ) && delete_option( PPW_Pro_Constants::LICENSE_OPTIONS );
		}

		public function get_license_type() {
			$app_id             = get_site_option( PPW_Pro_Constants::APP_ID, null );
			$not_available_type = 'N/A';

			if ( is_null( $app_id ) ) {
				return $not_available_type;
			}

			$license_map = [
				'77808414' => '3-site subscription license',
				'78043506' => '10-site subscription license',
				'78043507' => '15-site subscription license',
				'78022875' => '3-site lifetime license',
				'78043526' => '10-site lifetime license',
				'78043515' => '15-site lifetime license',
			];

			return isset( $license_map[ $app_id ] ) ? $license_map[ $app_id ] : $not_available_type;

		}

		public function verify_key( $api_key ) {
			$bodyInput = array(
				'siteUrl' => site_url(),
				'id'      => get_option( PPW_Pro_Constants::LICENSE_KEY, '' ),
			);

			$configs = require( PPW_PRO_DIR_PATH . '/includes/class-ppw-pro-configs.php' );
			$url     = $configs->verify_url;

			$args = array(
				'body'        => wp_json_encode( $bodyInput ),
				'timeout'     => '5000',
				'redirection' => '5',
				'httpversion' => '1.0',
				'blocking'    => true,
				'headers'     => array(
					'Content-Type' => 'application/json',
					'x-api-key'    => $api_key,
				),
				'cookies'     => array(),
			);

			$response    = wp_remote_post( $url, $args );
			$status_code = wp_remote_retrieve_response_code( $response );

			if ( 200 === $status_code ) {
				$body = wp_remote_retrieve_body( $response );
				$body = json_decode( $body );

				return isset( $body->success ) ? $body->success : false;
			}

			return false;
		}

		/**
		 * @return array
		 */
		public function check_addon( $addon ) {
			$bodyInput = array(
				'addon'   => $addon,
				'id'      => get_option( PPW_Pro_Constants::LICENSE_KEY, '' ),
			);

			$configs = require( PPW_PRO_DIR_PATH . '/includes/class-ppw-pro-configs.php' );
			$url     = $configs->addon_url;
			$key     = $configs->addon_key;

			$args = array(
				'body'        => wp_json_encode( $bodyInput ),
				'timeout'     => '5000',
				'redirection' => '5',
				'httpversion' => '1.0',
				'blocking'    => true,
				'headers'     => array(
					'Content-Type' => 'application/json',
					'x-api-key'    => $key,
				),
				'cookies'     => array(),
			);

			$response    = wp_remote_post( $url, $args );
			$status_code = wp_remote_retrieve_response_code( $response );

			if ( 200 === $status_code || 400 === $status_code ) {
				$body = wp_remote_retrieve_body( $response );
				$body = json_decode( $body );

				return array(
					'success' => isset( $body->success ) ? $body->success : false,
					'message' => isset( $body->message ) ? $body->message : '',
				);
			}

			return array(
				'success' => false,
				'message' => '',
			);
		}

		/**
		 * Check condition and get license info from server
		 *
		 * @return mixed|null
		 * return null if don't exist method getLicenseInfo in class YME_LICENSE.
		 * else return mixed(license info).
		 */
		public function fetch_license_info() {
			if ( ! method_exists( 'YME_LICENSE', 'getLicenseInfo' ) ) {
				return null;
			}

			return YME_LICENSE::getLicenseInfo( PPW_Pro_Constants::LICENSE_KEY );
		}

		/**
		 * Get license info from option.
		 *
		 * @return array
		 */
		public function get_license_info() {
			$license_info = get_option( PPW_Pro_Constants::LICENSE_INFO, array() );
			if ( ! $license_info ) {
				return [];
			}

			return (array) json_decode(
				base64_decode( $license_info )
			);
		}

		/**
		 * Update license information.
		 *
		 * @return object|null License information from server.
		 */
		public function update_license_info() {
			$license_info = $this->fetch_license_info();
			update_option( PPW_Pro_Constants::LICENSE_INFO, base64_encode( wp_json_encode( $license_info ) ), 'no' );

			return $license_info;
		}

		/**
		 * Recheck license and update product ID.
		 *
		 * @return array
		 */
		public function recheck_license() {
			$default_response = array(
				'success' => true,
				'message' => 'Your settings have been updated successfully!',
			);
			$license_info = $this->update_license_info();
			if ( ! empty( $license_info->upgraded_products ) ) {
				$product_ids             = explode( ';', $license_info->upgraded_products );
				$last_product_id         = end( $product_ids );
				$need_upgrade_product_id = ! empty( $last_product_id );
				if ( $need_upgrade_product_id ) {
					update_site_option( PPW_Pro_Constants::APP_ID, $last_product_id );
				} else {
					return array(
						'success' => false,
						'message' => 'Oops! Please contact to our support.',
					);
				}
			} elseif ( ! empty( $license_info->product_id ) ) {
				update_site_option( PPW_Pro_Constants::APP_ID, $license_info->product_id );
			}

			return $default_response;
		}

		public function should_display_license_input() {
			$message_option = get_option( 'ppwp_update_info' );

			if ( empty( $message_option ) ) {
				return false;
			}
			$message_option = (array) json_decode( $message_option );

			return ! empty( $message_option['message'] ) && ! empty( $message_option['blocked_download'] );
		}

		public function convert_addons_to_string( $addons ) {
			if ( empty( $addons ) ) {
				return '';
			}
			$massaged_addons = array_filter( array_map( function ( $addon ) {
				return self::addons( $addon );
			}, explode( ';', $addons ) ), function ( $item ) {
				return ! empty( $item );
			} );

			return implode( ', ', $massaged_addons );
		}
	}
}
