<?php
if ( ! class_exists( 'PPW_Pro_Category_Services' ) ) {
	class PPW_Pro_Category_Services extends PPW_Password_Services {
		/**
		 * @var PPW_Pro_Password_Services
		 */
		private $password_services;

		protected static $instance = null;

		public static function get_instance() {
			if ( null === self::$instance ) {
				self::$instance = new PPW_Pro_Category_Services();
			}

			return self::$instance;
		}

		/**
		 * PPW_Pro_Password_Services constructor.
		 */
		public function __construct() {
			$this->password_services = new PPW_Pro_Password_Services();
		}

		public function register() {
			add_action( 'wp', array( $this, 'maybe_protect_category_page' ), 15 );
		}


		public function maybe_protect_category_page() {
			if ( ! class_exists( 'PPW_Category_Service' ) ) {
				return;
			}
			if ( ! is_category() ) {
				return;
			}
			$allowed = apply_filters( 'ppwp_enable_category_page_protection', false );
			if ( ! $allowed ) {
				return;
			}

			$is_protect = ppw_core_get_setting_type_bool_by_option_name( 'ppwp_is_protect_category', PPW_Category_Service::OPTION_NAME );
			if ( ! $is_protect ) {
				return;
			}

			$term_id = get_queried_object_id();
			if ( isset( $_POST['post_password'] )
			     && isset( $_GET['action'] )
			     && 'ppwp_cat' === $_GET['action']
			) {
				$password = wp_unslash( $_POST['post_password'] );
				$is_valid = PPW_Category_Service::get_instance()->is_valid_password( $term_id, $password, false );

				do_action( 'ppw_redirect_after_enter_password', $is_valid );
			}

			$protected_categories = ppw_core_get_setting_type_array_by_option_name( 'ppwp_protected_categories_selected', PPW_Category_Service::OPTION_NAME );

			if ( ! in_array( $term_id, $protected_categories ) ) {
				return;
			}

			if ( $this->password_services->is_whitelist_roles( false ) || PPW_Category_Service::get_instance()->is_valid_cookie() ) {
				global $ppwp_unlock_whole_cat;
				$ppwp_unlock_whole_cat = 'pro';

				return;
			}

			add_filter( 'ppwp_ppf_action_url', function ( $url ) {
				return add_query_arg(
					array(
						'action' => 'ppwp_cat',
						'type'   => 'cat',
					),
					$url
				);
			}, 99999 );
			add_filter( 'ppw_not_reload_excluded', '__return_true' );

			$title = get_term( $term_id )->name;
			add_filter(
				'ppwp_customize_password_form',
				function ( $content ) use ( $title ) {
					return '<h1>' . $title . '</h1>' . $content;
				}
			);

			ob_start();
			get_header();
			?>
			<main id="ppwp-main-content" class="main-content">
				<div class="entry-content">
					<?php
					do_action( 'ppwpg_above_archive_password_form' );
					echo ppw_core_render_login_form();
					?>
				</div>
			</main>
			<?php
			get_footer();
			echo ob_get_clean();
			exit();
		}

		/**
		 * @param $term_id
		 *
		 * @return string
		 */
		public function get_all_parent_category( $term_id ) {
			if ( 0 === get_category( $term_id )->parent ) {
				return "";
			}

			$arr_all_id_parent = [];
			do {
				$term_id = get_category( $term_id )->parent;
				if ( $term_id !== 0 ) {
					array_push( $arr_all_id_parent, $term_id );
				}
			} while ( $term_id !== 0 );

			return implode( ";", $arr_all_id_parent );
		}


		/**
		 * @param $all_post
		 *
		 * @return array
		 * @throws Exception
		 */
		public function update_category_protect( $all_post ) {
			$all_post_id         = explode( ";", $all_post );
			$is_protect_category = $this->password_services->is_protected_all_posts( $all_post_id );

			if ( $is_protect_category ) {
				foreach ( $all_post_id as $post_id ) {
					update_post_meta( $post_id, PPW_Pro_Constants::AUTO_GENERATE_PWD_META_DATA, "false" );
				}

				return $all_post_id;
			}

			foreach ( $all_post_id as $post_id ) {
				$this->password_services->protect_post_by_password( $post_id );
			}

			return $all_post_id;
		}

		/**
		 * @param $post_id
		 *
		 * @return array
		 */
		public function check_category_parent_protect( $post_id ) {
			$category      = get_the_category( $post_id );
			$all_parent_id = $this->get_all_parent_category( $category[0]->term_id );
			if ( ! empty( $all_parent_id ) ) {
				$arr_parent = array_map( function ( $parent_id ) {
					return [
						"id"         => $parent_id,
						"is_protect" => $this->check_is_protect_category( $parent_id ),
					];
				}, explode( ";", $all_parent_id ) );
			}
			return isset( $arr_parent ) ? $arr_parent : [];
		}

		/**
		 * @param $parent_id
		 *
		 * @return bool
		 */
		public function check_is_protect_category( $parent_id ) {
			$post_ids = $this->get_all_category( $parent_id );

			return $this->password_services->is_protected_all_posts( $post_ids );
		}

		/**
		 * @param $term_id
		 *
		 * @return mixed
		 */
		public function get_all_category( $term_id ) {
			return get_posts( array(
				'numberposts' => - 1,
				'tax_query'   => array(
					array(
						'taxonomy' => 'category',
						'field'    => 'id',
						'terms'    => $term_id,
					),
				),
				'fields'      => 'ids',
			) );
		}


		/**
		 * @throws Exception
		 */
		public function update_category_protect_response() {
			$nonce = $_REQUEST['security_check'];
			if ( ! wp_verify_nonce( $nonce, PPW_Pro_Constants::UPDATE_PROTECT_CATEGORY_FORM_NONCE ) ) {
				send_json_data_error( 'Invalid nonce' );
			}
			if ( ! $_REQUEST['all_post_id'] ) {
				send_json_data_error( 'Invalid nonce' );
			}
			$all_post_id = $this->update_category_protect( $_REQUEST['all_post_id'] );
			wp_send_json( $this->check_category_parent_protect( $all_post_id[0])  );
			wp_die();
		}

		/**
		 * @param $post_ids
		 *
		 * @return bool
		 */
		public function is_protected_all_posts( $post_ids ) {
			return $this->password_services->is_protected_all_posts( $post_ids );
		}

	}
}
